/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ApplicationSettings;
import software.amazon.awssdk.services.appstream.model.EmbedHostDomainsCopier;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.services.appstream.model.UserSetting;
import software.amazon.awssdk.services.appstream.model.UserSettingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStackRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateStackRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateStackRequest.getter(CreateStackRequest::name)).setter(CreateStackRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateStackRequest.getter(CreateStackRequest::description)).setter(CreateStackRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateStackRequest.getter(CreateStackRequest::displayName)).setter(CreateStackRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageConnectors").getter(CreateStackRequest.getter(CreateStackRequest::storageConnectors)).setter(CreateStackRequest.setter(Builder::storageConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectURL").getter(CreateStackRequest.getter(CreateStackRequest::redirectURL)).setter(CreateStackRequest.setter(Builder::redirectURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectURL").build()}).build();
    private static final SdkField<String> FEEDBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackURL").getter(CreateStackRequest.getter(CreateStackRequest::feedbackURL)).setter(CreateStackRequest.setter(Builder::feedbackURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackURL").build()}).build();
    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserSettings").getter(CreateStackRequest.getter(CreateStackRequest::userSettings)).setter(CreateStackRequest.setter(Builder::userSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationSettings> APPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSettings").getter(CreateStackRequest.getter(CreateStackRequest::applicationSettings)).setter(CreateStackRequest.setter(Builder::applicationSettings)).constructor(ApplicationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateStackRequest.getter(CreateStackRequest::tags)).setter(CreateStackRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessEndpoints").getter(CreateStackRequest.getter(CreateStackRequest::accessEndpoints)).setter(CreateStackRequest.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EMBED_HOST_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmbedHostDomains").getter(CreateStackRequest.getter(CreateStackRequest::embedHostDomains)).setter(CreateStackRequest.setter(Builder::embedHostDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmbedHostDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, STORAGE_CONNECTORS_FIELD, REDIRECT_URL_FIELD, FEEDBACK_URL_FIELD, USER_SETTINGS_FIELD, APPLICATION_SETTINGS_FIELD, TAGS_FIELD, ACCESS_ENDPOINTS_FIELD, EMBED_HOST_DOMAINS_FIELD));
    private final String name;
    private final String description;
    private final String displayName;
    private final List<StorageConnector> storageConnectors;
    private final String redirectURL;
    private final String feedbackURL;
    private final List<UserSetting> userSettings;
    private final ApplicationSettings applicationSettings;
    private final Map<String, String> tags;
    private final List<AccessEndpoint> accessEndpoints;
    private final List<String> embedHostDomains;

    private CreateStackRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.storageConnectors = builder.storageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
        this.tags = builder.tags;
        this.accessEndpoints = builder.accessEndpoints;
        this.embedHostDomains = builder.embedHostDomains;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasStorageConnectors() {
        return this.storageConnectors != null && !(this.storageConnectors instanceof SdkAutoConstructList);
    }

    public final List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public final String redirectURL() {
        return this.redirectURL;
    }

    public final String feedbackURL() {
        return this.feedbackURL;
    }

    public final boolean hasUserSettings() {
        return this.userSettings != null && !(this.userSettings instanceof SdkAutoConstructList);
    }

    public final List<UserSetting> userSettings() {
        return this.userSettings;
    }

    public final ApplicationSettings applicationSettings() {
        return this.applicationSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public final List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    public final boolean hasEmbedHostDomains() {
        return this.embedHostDomains != null && !(this.embedHostDomains instanceof SdkAutoConstructList);
    }

    public final List<String> embedHostDomains() {
        return this.embedHostDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConnectors() ? this.storageConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserSettings() ? this.userSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessEndpoints() ? this.accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmbedHostDomains() ? this.embedHostDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && this.hasStorageConnectors() == other.hasStorageConnectors() && Objects.equals(this.storageConnectors(), other.storageConnectors()) && Objects.equals(this.redirectURL(), other.redirectURL()) && Objects.equals(this.feedbackURL(), other.feedbackURL()) && this.hasUserSettings() == other.hasUserSettings() && Objects.equals(this.userSettings(), other.userSettings()) && Objects.equals(this.applicationSettings(), other.applicationSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAccessEndpoints() == other.hasAccessEndpoints() && Objects.equals(this.accessEndpoints(), other.accessEndpoints()) && this.hasEmbedHostDomains() == other.hasEmbedHostDomains() && Objects.equals(this.embedHostDomains(), other.embedHostDomains());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStackRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("StorageConnectors", this.hasStorageConnectors() ? this.storageConnectors() : null).add("RedirectURL", (Object)this.redirectURL()).add("FeedbackURL", (Object)this.feedbackURL()).add("UserSettings", this.hasUserSettings() ? this.userSettings() : null).add("ApplicationSettings", (Object)this.applicationSettings()).add("Tags", this.hasTags() ? this.tags() : null).add("AccessEndpoints", this.hasAccessEndpoints() ? this.accessEndpoints() : null).add("EmbedHostDomains", this.hasEmbedHostDomains() ? this.embedHostDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "StorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.storageConnectors()));
            }
            case "RedirectURL": {
                return Optional.ofNullable(clazz.cast(this.redirectURL()));
            }
            case "FeedbackURL": {
                return Optional.ofNullable(clazz.cast(this.feedbackURL()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
            case "EmbedHostDomains": {
                return Optional.ofNullable(clazz.cast(this.embedHostDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRequest, T> g) {
        return obj -> g.apply((CreateStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String displayName;
        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();
        private String redirectURL;
        private String feedbackURL;
        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();
        private ApplicationSettings applicationSettings;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> embedHostDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.displayName(model.displayName);
            this.storageConnectors(model.storageConnectors);
            this.redirectURL(model.redirectURL);
            this.feedbackURL(model.feedbackURL);
            this.userSettings(model.userSettings);
            this.applicationSettings(model.applicationSettings);
            this.tags(model.tags);
            this.accessEndpoints(model.accessEndpoints);
            this.embedHostDomains(model.embedHostDomains);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final List<StorageConnector.Builder> getStorageConnectors() {
            List<StorageConnector.Builder> result = StorageConnectorListCopier.copyToBuilder(this.storageConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder> ... storageConnectors) {
            this.storageConnectors(Stream.of(storageConnectors).map(c -> (StorageConnector)((StorageConnector.Builder)StorageConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final String getRedirectURL() {
            return this.redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        public final String getFeedbackURL() {
            return this.feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        public final List<UserSetting.Builder> getUserSettings() {
            List<UserSetting.Builder> result = UserSettingListCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting ... userSettings) {
            this.userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder> ... userSettings) {
            this.userSettings(Stream.of(userSettings).map(c -> (UserSetting)((UserSetting.Builder)UserSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        public final ApplicationSettings.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final void setApplicationSettings(ApplicationSettings.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        public final Collection<String> getEmbedHostDomains() {
            if (this.embedHostDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.embedHostDomains;
        }

        @Override
        public final Builder embedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embedHostDomains(String ... embedHostDomains) {
            this.embedHostDomains(Arrays.asList(embedHostDomains));
            return this;
        }

        public final void setEmbedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStackRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder storageConnectors(Consumer<StorageConnector.Builder> ... var1);

        public Builder redirectURL(String var1);

        public Builder feedbackURL(String var1);

        public Builder userSettings(Collection<UserSetting> var1);

        public Builder userSettings(UserSetting ... var1);

        public Builder userSettings(Consumer<UserSetting.Builder> ... var1);

        public Builder applicationSettings(ApplicationSettings var1);

        default public Builder applicationSettings(Consumer<ApplicationSettings.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettings)((ApplicationSettings.Builder)ApplicationSettings.builder().applyMutation(applicationSettings)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);

        public Builder embedHostDomains(Collection<String> var1);

        public Builder embedHostDomains(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

