/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the error that is returned when a user can’t be associated with or disassociated from a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserStackAssociationError implements SdkPojo, Serializable,
        ToCopyableBuilder<UserStackAssociationError.Builder, UserStackAssociationError> {
    private static final SdkField<UserStackAssociation> USER_STACK_ASSOCIATION_FIELD = SdkField
            .<UserStackAssociation> builder(MarshallingType.SDK_POJO).memberName("UserStackAssociation")
            .getter(getter(UserStackAssociationError::userStackAssociation)).setter(setter(Builder::userStackAssociation))
            .constructor(UserStackAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStackAssociation").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(UserStackAssociationError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(UserStackAssociationError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_STACK_ASSOCIATION_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final UserStackAssociation userStackAssociation;

    private final String errorCode;

    private final String errorMessage;

    private UserStackAssociationError(BuilderImpl builder) {
        this.userStackAssociation = builder.userStackAssociation;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Information about the user and associated stack.
     * </p>
     * 
     * @return Information about the user and associated stack.
     */
    public final UserStackAssociation userStackAssociation() {
        return userStackAssociation;
    }

    /**
     * <p>
     * The error code for the error that is returned when a user can’t be associated with or disassociated from a stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UserStackAssociationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the error that is returned when a user can’t be associated with or disassociated from
     *         a stack.
     * @see UserStackAssociationErrorCode
     */
    public final UserStackAssociationErrorCode errorCode() {
        return UserStackAssociationErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code for the error that is returned when a user can’t be associated with or disassociated from a stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UserStackAssociationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the error that is returned when a user can’t be associated with or disassociated from
     *         a stack.
     * @see UserStackAssociationErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The error message for the error that is returned when a user can’t be associated with or disassociated from a
     * stack.
     * </p>
     * 
     * @return The error message for the error that is returned when a user can’t be associated with or disassociated
     *         from a stack.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userStackAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserStackAssociationError)) {
            return false;
        }
        UserStackAssociationError other = (UserStackAssociationError) obj;
        return Objects.equals(userStackAssociation(), other.userStackAssociation())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserStackAssociationError").add("UserStackAssociation", userStackAssociation())
                .add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserStackAssociation":
            return Optional.ofNullable(clazz.cast(userStackAssociation()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserStackAssociationError, T> g) {
        return obj -> g.apply((UserStackAssociationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserStackAssociationError> {
        /**
         * <p>
         * Information about the user and associated stack.
         * </p>
         * 
         * @param userStackAssociation
         *        Information about the user and associated stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStackAssociation(UserStackAssociation userStackAssociation);

        /**
         * <p>
         * Information about the user and associated stack.
         * </p>
         * This is a convenience that creates an instance of the {@link UserStackAssociation.Builder} avoiding the need
         * to create one manually via {@link UserStackAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserStackAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #userStackAssociation(UserStackAssociation)}.
         * 
         * @param userStackAssociation
         *        a consumer that will call methods on {@link UserStackAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userStackAssociation(UserStackAssociation)
         */
        default Builder userStackAssociation(Consumer<UserStackAssociation.Builder> userStackAssociation) {
            return userStackAssociation(UserStackAssociation.builder().applyMutation(userStackAssociation).build());
        }

        /**
         * <p>
         * The error code for the error that is returned when a user can’t be associated with or disassociated from a
         * stack.
         * </p>
         * 
         * @param errorCode
         *        The error code for the error that is returned when a user can’t be associated with or disassociated
         *        from a stack.
         * @see UserStackAssociationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStackAssociationErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code for the error that is returned when a user can’t be associated with or disassociated from a
         * stack.
         * </p>
         * 
         * @param errorCode
         *        The error code for the error that is returned when a user can’t be associated with or disassociated
         *        from a stack.
         * @see UserStackAssociationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStackAssociationErrorCode
         */
        Builder errorCode(UserStackAssociationErrorCode errorCode);

        /**
         * <p>
         * The error message for the error that is returned when a user can’t be associated with or disassociated from a
         * stack.
         * </p>
         * 
         * @param errorMessage
         *        The error message for the error that is returned when a user can’t be associated with or disassociated
         *        from a stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private UserStackAssociation userStackAssociation;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UserStackAssociationError model) {
            userStackAssociation(model.userStackAssociation);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final UserStackAssociation.Builder getUserStackAssociation() {
            return userStackAssociation != null ? userStackAssociation.toBuilder() : null;
        }

        @Override
        public final Builder userStackAssociation(UserStackAssociation userStackAssociation) {
            this.userStackAssociation = userStackAssociation;
            return this;
        }

        public final void setUserStackAssociation(UserStackAssociation.BuilderImpl userStackAssociation) {
            this.userStackAssociation = userStackAssociation != null ? userStackAssociation.build() : null;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UserStackAssociationErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public UserStackAssociationError build() {
            return new UserStackAssociationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
