/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ServiceStatus {
    CREATE_FAILED("CREATE_FAILED"),
    RUNNING("RUNNING"),
    DELETED("DELETED"),
    DELETE_FAILED("DELETE_FAILED"),
    PAUSED("PAUSED"),
    OPERATION_IN_PROGRESS("OPERATION_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ServiceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ServiceStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceStatus> knownValues() {
        return Stream.of(ServiceStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

