/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary;
import software.amazon.awssdk.services.apprunner.model.EncryptionConfiguration;
import software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration;
import software.amazon.awssdk.services.apprunner.model.InstanceConfiguration;
import software.amazon.awssdk.services.apprunner.model.ServiceStatus;
import software.amazon.awssdk.services.apprunner.model.SourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Service> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(Service.getter(Service::serviceName)).setter(Service.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(Service.getter(Service::serviceId)).setter(Service.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceArn").getter(Service.getter(Service::serviceArn)).setter(Service.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()}).build();
    private static final SdkField<String> SERVICE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUrl").getter(Service.getter(Service::serviceUrl)).setter(Service.setter(Builder::serviceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUrl").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Service.getter(Service::createdAt)).setter(Service.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Service.getter(Service::updatedAt)).setter(Service.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletedAt").getter(Service.getter(Service::deletedAt)).setter(Service.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Service.getter(Service::statusAsString)).setter(Service.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConfiguration").getter(Service.getter(Service::sourceConfiguration)).setter(Service.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build()}).build();
    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceConfiguration").getter(Service.getter(Service::instanceConfiguration)).setter(Service.setter(Builder::instanceConfiguration)).constructor(InstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConfiguration").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(Service.getter(Service::encryptionConfiguration)).setter(Service.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<HealthCheckConfiguration> HEALTH_CHECK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheckConfiguration").getter(Service.getter(Service::healthCheckConfiguration)).setter(Service.setter(Builder::healthCheckConfiguration)).constructor(HealthCheckConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfiguration").build()}).build();
    private static final SdkField<AutoScalingConfigurationSummary> AUTO_SCALING_CONFIGURATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoScalingConfigurationSummary").getter(Service.getter(Service::autoScalingConfigurationSummary)).setter(Service.setter(Builder::autoScalingConfigurationSummary)).constructor(AutoScalingConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, SERVICE_ID_FIELD, SERVICE_ARN_FIELD, SERVICE_URL_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DELETED_AT_FIELD, STATUS_FIELD, SOURCE_CONFIGURATION_FIELD, INSTANCE_CONFIGURATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, HEALTH_CHECK_CONFIGURATION_FIELD, AUTO_SCALING_CONFIGURATION_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final String serviceId;
    private final String serviceArn;
    private final String serviceUrl;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant deletedAt;
    private final String status;
    private final SourceConfiguration sourceConfiguration;
    private final InstanceConfiguration instanceConfiguration;
    private final EncryptionConfiguration encryptionConfiguration;
    private final HealthCheckConfiguration healthCheckConfiguration;
    private final AutoScalingConfigurationSummary autoScalingConfigurationSummary;

    private Service(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceId = builder.serviceId;
        this.serviceArn = builder.serviceArn;
        this.serviceUrl = builder.serviceUrl;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.deletedAt = builder.deletedAt;
        this.status = builder.status;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.healthCheckConfiguration = builder.healthCheckConfiguration;
        this.autoScalingConfigurationSummary = builder.autoScalingConfigurationSummary;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String serviceUrl() {
        return this.serviceUrl;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public final ServiceStatus status() {
        return ServiceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final InstanceConfiguration instanceConfiguration() {
        return this.instanceConfiguration;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final HealthCheckConfiguration healthCheckConfiguration() {
        return this.healthCheckConfiguration;
    }

    public final AutoScalingConfigurationSummary autoScalingConfigurationSummary() {
        return this.autoScalingConfigurationSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.serviceUrl(), other.serviceUrl()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.deletedAt(), other.deletedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && Objects.equals(this.instanceConfiguration(), other.instanceConfiguration()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.healthCheckConfiguration(), other.healthCheckConfiguration()) && Objects.equals(this.autoScalingConfigurationSummary(), other.autoScalingConfigurationSummary());
    }

    public final String toString() {
        return ToString.builder((String)"Service").add("ServiceName", (Object)this.serviceName()).add("ServiceId", (Object)this.serviceId()).add("ServiceArn", (Object)this.serviceArn()).add("ServiceUrl", (Object)this.serviceUrl()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DeletedAt", (Object)this.deletedAt()).add("Status", (Object)this.statusAsString()).add("SourceConfiguration", (Object)this.sourceConfiguration()).add("InstanceConfiguration", (Object)this.instanceConfiguration()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("HealthCheckConfiguration", (Object)this.healthCheckConfiguration()).add("AutoScalingConfigurationSummary", (Object)this.autoScalingConfigurationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "ServiceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "ServiceUrl": {
                return Optional.ofNullable(clazz.cast(this.serviceUrl()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "DeletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "InstanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceConfiguration()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "HealthCheckConfiguration": {
                return Optional.ofNullable(clazz.cast(this.healthCheckConfiguration()));
            }
            case "AutoScalingConfigurationSummary": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private String serviceId;
        private String serviceArn;
        private String serviceUrl;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant deletedAt;
        private String status;
        private SourceConfiguration sourceConfiguration;
        private InstanceConfiguration instanceConfiguration;
        private EncryptionConfiguration encryptionConfiguration;
        private HealthCheckConfiguration healthCheckConfiguration;
        private AutoScalingConfigurationSummary autoScalingConfigurationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.serviceName(model.serviceName);
            this.serviceId(model.serviceId);
            this.serviceArn(model.serviceArn);
            this.serviceUrl(model.serviceUrl);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.deletedAt(model.deletedAt);
            this.status(model.status);
            this.sourceConfiguration(model.sourceConfiguration);
            this.instanceConfiguration(model.instanceConfiguration);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.healthCheckConfiguration(model.healthCheckConfiguration);
            this.autoScalingConfigurationSummary(model.autoScalingConfigurationSummary);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        public final String getServiceUrl() {
            return this.serviceUrl;
        }

        @Override
        public final Builder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public final void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return this.instanceConfiguration != null ? this.instanceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final HealthCheckConfiguration.Builder getHealthCheckConfiguration() {
            return this.healthCheckConfiguration != null ? this.healthCheckConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfiguration(HealthCheckConfiguration healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        public final void setHealthCheckConfiguration(HealthCheckConfiguration.BuilderImpl healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration != null ? healthCheckConfiguration.build() : null;
        }

        public final AutoScalingConfigurationSummary.Builder getAutoScalingConfigurationSummary() {
            return this.autoScalingConfigurationSummary != null ? this.autoScalingConfigurationSummary.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingConfigurationSummary(AutoScalingConfigurationSummary autoScalingConfigurationSummary) {
            this.autoScalingConfigurationSummary = autoScalingConfigurationSummary;
            return this;
        }

        public final void setAutoScalingConfigurationSummary(AutoScalingConfigurationSummary.BuilderImpl autoScalingConfigurationSummary) {
            this.autoScalingConfigurationSummary = autoScalingConfigurationSummary != null ? autoScalingConfigurationSummary.build() : null;
        }

        public Service build() {
            return new Service(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Service> {
        public Builder serviceName(String var1);

        public Builder serviceId(String var1);

        public Builder serviceArn(String var1);

        public Builder serviceUrl(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder deletedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ServiceStatus var1);

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder instanceConfiguration(InstanceConfiguration var1);

        default public Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return this.instanceConfiguration((InstanceConfiguration)((InstanceConfiguration.Builder)InstanceConfiguration.builder().applyMutation(instanceConfiguration)).build());
        }

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder healthCheckConfiguration(HealthCheckConfiguration var1);

        default public Builder healthCheckConfiguration(Consumer<HealthCheckConfiguration.Builder> healthCheckConfiguration) {
            return this.healthCheckConfiguration((HealthCheckConfiguration)((HealthCheckConfiguration.Builder)HealthCheckConfiguration.builder().applyMutation(healthCheckConfiguration)).build());
        }

        public Builder autoScalingConfigurationSummary(AutoScalingConfigurationSummary var1);

        default public Builder autoScalingConfigurationSummary(Consumer<AutoScalingConfigurationSummary.Builder> autoScalingConfigurationSummary) {
            return this.autoScalingConfigurationSummary((AutoScalingConfigurationSummary)((AutoScalingConfigurationSummary.Builder)AutoScalingConfigurationSummary.builder().applyMutation(autoScalingConfigurationSummary)).build());
        }
    }
}

