/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConfigurationSource {
    REPOSITORY("REPOSITORY"),
    API("API"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConfigurationSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConfigurationSource.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationSource> knownValues() {
        return Stream.of(ConfigurationSource.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

