/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetricType {
    DYNAMO_DB_READ_CAPACITY_UTILIZATION("DynamoDBReadCapacityUtilization"),
    DYNAMO_DB_WRITE_CAPACITY_UTILIZATION("DynamoDBWriteCapacityUtilization"),
    ALB_REQUEST_COUNT_PER_TARGET("ALBRequestCountPerTarget"),
    RDS_READER_AVERAGE_CPU_UTILIZATION("RDSReaderAverageCPUUtilization"),
    RDS_READER_AVERAGE_DATABASE_CONNECTIONS("RDSReaderAverageDatabaseConnections"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION("EC2SpotFleetRequestAverageCPUUtilization"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN("EC2SpotFleetRequestAverageNetworkIn"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT("EC2SpotFleetRequestAverageNetworkOut"),
    SAGE_MAKER_VARIANT_INVOCATIONS_PER_INSTANCE("SageMakerVariantInvocationsPerInstance"),
    ECS_SERVICE_AVERAGE_CPU_UTILIZATION("ECSServiceAverageCPUUtilization"),
    ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION("ECSServiceAverageMemoryUtilization"),
    APP_STREAM_AVERAGE_CAPACITY_UTILIZATION("AppStreamAverageCapacityUtilization"),
    COMPREHEND_INFERENCE_UTILIZATION("ComprehendInferenceUtilization"),
    LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION("LambdaProvisionedConcurrencyUtilization"),
    CASSANDRA_READ_CAPACITY_UTILIZATION("CassandraReadCapacityUtilization"),
    CASSANDRA_WRITE_CAPACITY_UTILIZATION("CassandraWriteCapacityUtilization"),
    KAFKA_BROKER_STORAGE_UTILIZATION("KafkaBrokerStorageUtilization"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetricType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricType> knownValues() {
        return Stream.of(MetricType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

