/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.services.appconfig.model.GrowthType;
import software.amazon.awssdk.services.appconfig.model.ReplicateTo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentStrategyResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, CreateDeploymentStrategyResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::id)).setter(CreateDeploymentStrategyResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::name)).setter(CreateDeploymentStrategyResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::description)).setter(CreateDeploymentStrategyResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeploymentDurationInMinutes").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::deploymentDurationInMinutes)).setter(CreateDeploymentStrategyResponse.setter(Builder::deploymentDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes").build()}).build();
    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrowthType").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::growthTypeAsString)).setter(CreateDeploymentStrategyResponse.setter(Builder::growthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()}).build();
    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("GrowthFactor").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::growthFactor)).setter(CreateDeploymentStrategyResponse.setter(Builder::growthFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()}).build();
    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FinalBakeTimeInMinutes").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::finalBakeTimeInMinutes)).setter(CreateDeploymentStrategyResponse.setter(Builder::finalBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build()}).build();
    private static final SdkField<String> REPLICATE_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicateTo").getter(CreateDeploymentStrategyResponse.getter(CreateDeploymentStrategyResponse::replicateToAsString)).setter(CreateDeploymentStrategyResponse.setter(Builder::replicateTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicateTo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, GROWTH_TYPE_FIELD, GROWTH_FACTOR_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, REPLICATE_TO_FIELD));
    private final String id;
    private final String name;
    private final String description;
    private final Integer deploymentDurationInMinutes;
    private final String growthType;
    private final Float growthFactor;
    private final Integer finalBakeTimeInMinutes;
    private final String replicateTo;

    private CreateDeploymentStrategyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.growthType = builder.growthType;
        this.growthFactor = builder.growthFactor;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.replicateTo = builder.replicateTo;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Integer deploymentDurationInMinutes() {
        return this.deploymentDurationInMinutes;
    }

    public final GrowthType growthType() {
        return GrowthType.fromValue(this.growthType);
    }

    public final String growthTypeAsString() {
        return this.growthType;
    }

    public final Float growthFactor() {
        return this.growthFactor;
    }

    public final Integer finalBakeTimeInMinutes() {
        return this.finalBakeTimeInMinutes;
    }

    public final ReplicateTo replicateTo() {
        return ReplicateTo.fromValue(this.replicateTo);
    }

    public final String replicateToAsString() {
        return this.replicateTo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicateToAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentStrategyResponse)) {
            return false;
        }
        CreateDeploymentStrategyResponse other = (CreateDeploymentStrategyResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deploymentDurationInMinutes(), other.deploymentDurationInMinutes()) && Objects.equals(this.growthTypeAsString(), other.growthTypeAsString()) && Objects.equals(this.growthFactor(), other.growthFactor()) && Objects.equals(this.finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes()) && Objects.equals(this.replicateToAsString(), other.replicateToAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentStrategyResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DeploymentDurationInMinutes", (Object)this.deploymentDurationInMinutes()).add("GrowthType", (Object)this.growthTypeAsString()).add("GrowthFactor", (Object)this.growthFactor()).add("FinalBakeTimeInMinutes", (Object)this.finalBakeTimeInMinutes()).add("ReplicateTo", (Object)this.replicateToAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeploymentDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.deploymentDurationInMinutes()));
            }
            case "GrowthType": {
                return Optional.ofNullable(clazz.cast(this.growthTypeAsString()));
            }
            case "GrowthFactor": {
                return Optional.ofNullable(clazz.cast(this.growthFactor()));
            }
            case "FinalBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.finalBakeTimeInMinutes()));
            }
            case "ReplicateTo": {
                return Optional.ofNullable(clazz.cast(this.replicateToAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentStrategyResponse, T> g) {
        return obj -> g.apply((CreateDeploymentStrategyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private Integer deploymentDurationInMinutes;
        private String growthType;
        private Float growthFactor;
        private Integer finalBakeTimeInMinutes;
        private String replicateTo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentStrategyResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            this.growthType(model.growthType);
            this.growthFactor(model.growthFactor);
            this.finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            this.replicateTo(model.replicateTo);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return this.deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        public final String getGrowthType() {
            return this.growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        public final Float getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return this.finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        public final String getReplicateTo() {
            return this.replicateTo;
        }

        @Override
        public final Builder replicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
            return this;
        }

        @Override
        public final Builder replicateTo(ReplicateTo replicateTo) {
            this.replicateTo(replicateTo == null ? null : replicateTo.toString());
            return this;
        }

        public final void setReplicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
        }

        @Override
        public CreateDeploymentStrategyResponse build() {
            return new CreateDeploymentStrategyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentStrategyResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder deploymentDurationInMinutes(Integer var1);

        public Builder growthType(String var1);

        public Builder growthType(GrowthType var1);

        public Builder growthFactor(Float var1);

        public Builder finalBakeTimeInMinutes(Integer var1);

        public Builder replicateTo(String var1);

        public Builder replicateTo(ReplicateTo var1);
    }
}

