/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.ApiKey;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;

public class GetApiKeysIterable
implements SdkIterable<GetApiKeysResponse> {
    private final ApiGatewayClient client;
    private final GetApiKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetApiKeysIterable(ApiGatewayClient client, GetApiKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetApiKeysResponseFetcher();
    }

    public Iterator<GetApiKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApiKey> items() {
        Function<GetApiKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetApiKeysResponseFetcher
    implements SyncPageFetcher<GetApiKeysResponse> {
        private GetApiKeysResponseFetcher() {
        }

        public boolean hasNextPage(GetApiKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetApiKeysResponse nextPage(GetApiKeysResponse previousPage) {
            if (previousPage == null) {
                return GetApiKeysIterable.this.client.getApiKeys(GetApiKeysIterable.this.firstRequest);
            }
            return GetApiKeysIterable.this.client.getApiKeys((GetApiKeysRequest)((Object)GetApiKeysIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

