/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum GatewayResponseType {
    DEFAULT_4_XX("DEFAULT_4XX"),
    DEFAULT_5_XX("DEFAULT_5XX"),
    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),
    UNAUTHORIZED("UNAUTHORIZED"),
    INVALID_API_KEY("INVALID_API_KEY"),
    ACCESS_DENIED("ACCESS_DENIED"),
    AUTHORIZER_FAILURE("AUTHORIZER_FAILURE"),
    AUTHORIZER_CONFIGURATION_ERROR("AUTHORIZER_CONFIGURATION_ERROR"),
    INVALID_SIGNATURE("INVALID_SIGNATURE"),
    EXPIRED_TOKEN("EXPIRED_TOKEN"),
    MISSING_AUTHENTICATION_TOKEN("MISSING_AUTHENTICATION_TOKEN"),
    INTEGRATION_FAILURE("INTEGRATION_FAILURE"),
    INTEGRATION_TIMEOUT("INTEGRATION_TIMEOUT"),
    API_CONFIGURATION_ERROR("API_CONFIGURATION_ERROR"),
    UNSUPPORTED_MEDIA_TYPE("UNSUPPORTED_MEDIA_TYPE"),
    BAD_REQUEST_PARAMETERS("BAD_REQUEST_PARAMETERS"),
    BAD_REQUEST_BODY("BAD_REQUEST_BODY"),
    REQUEST_TOO_LARGE("REQUEST_TOO_LARGE"),
    THROTTLED("THROTTLED"),
    QUOTA_EXCEEDED("QUOTA_EXCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private GatewayResponseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GatewayResponseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(GatewayResponseType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GatewayResponseType> knownValues() {
        return Stream.of(GatewayResponseType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

