/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.linter;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OptionsBuilder.class);

    public String[] splitOptions(String optionAsString) {
        return optionAsString == null ? ArrayUtils.EMPTY_STRING_ARRAY : optionAsString.split("(?ims),(?![^\\[\\]]*\\])");
    }

    public String buildFromCsv(String optionsAsCsv) {
        return this.build(this.splitOptions(optionsAsCsv));
    }

    public String build(String ... options) {
        LOG.debug("options: {}", (Object)Arrays.toString(options));
        StringBuffer sb = new StringBuffer("{");
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                String option = options[i];
                if (StringUtils.isEmpty((CharSequence)option)) continue;
                sb.append(this.processSingleOption(option));
                if (i >= options.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        LOG.debug("options: {}", (Object)sb);
        return sb.toString();
    }

    private String processSingleOption(String option) {
        String optionName = option;
        String optionValue = Boolean.TRUE.toString();
        if (option.contains("=")) {
            String[] optionEntry = option.split("=");
            if (optionEntry.length != 2) {
                throw new IllegalArgumentException("Invalid option provided: " + option);
            }
            optionName = optionEntry[0];
            optionValue = option.split("=")[1];
        }
        return String.format("\"%s\": %s", optionName.trim(), optionValue.trim());
    }
}

