/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.MessageLogger;
import org.zeroturnaround.exec.ProcessAttributes;
import org.zeroturnaround.exec.ProcessOutput;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.close.ProcessCloser;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stop.ProcessStopper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WaitForProcess
implements Callable<ProcessResult> {
    private static final Logger log = LoggerFactory.getLogger(WaitForProcess.class);
    private static final int MAX_OUTPUT_SIZE_IN_ERROR_MESSAGE = 5000;
    private final Process process;
    private final ProcessAttributes attributes;
    private final ProcessStopper stopper;
    private final ProcessCloser closer;
    private final ByteArrayOutputStream out;
    private final ProcessListener listener;
    private final MessageLogger messageLogger;
    private volatile Thread workerThread;

    public WaitForProcess(Process process, ProcessAttributes attributes, ProcessStopper stopper, ProcessCloser closer, ByteArrayOutputStream out, ProcessListener listener, MessageLogger messageLogger) {
        this.process = process;
        this.attributes = attributes;
        this.stopper = stopper;
        this.closer = closer;
        this.out = out;
        this.listener = listener;
        this.messageLogger = messageLogger;
    }

    public Process getProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProcessResult call() throws IOException, InterruptedException {
        try {
            int exit;
            block6: {
                this.workerThread = Thread.currentThread();
                boolean finished = false;
                try {
                    exit = this.process.waitFor();
                    finished = true;
                    this.messageLogger.message(log, "{} stopped with exit code {}", this, exit);
                    if (finished) break block6;
                }
                catch (Throwable throwable) {
                    if (!finished) {
                        this.messageLogger.message(log, "Stopping {}...", this);
                        this.stopper.stop(this.process);
                    }
                    this.closer.close(this.process);
                    throw throwable;
                }
                this.messageLogger.message(log, "Stopping {}...", this);
                this.stopper.stop(this.process);
            }
            this.closer.close(this.process);
            ProcessOutput output = this.getCurrentOutput();
            ProcessResult result = new ProcessResult(exit, output);
            this.checkExit(result);
            this.listener.afterFinish(this.process, result);
            ProcessResult processResult = result;
            return processResult;
        }
        finally {
            this.listener.afterStop(this.process);
            this.workerThread = null;
        }
    }

    private ProcessOutput getCurrentOutput() {
        return this.out == null ? null : new ProcessOutput(this.out.toByteArray());
    }

    private void checkExit(ProcessResult result) {
        Set<Integer> allowedExitValues = this.attributes.getAllowedExitValues();
        if (allowedExitValues != null && !allowedExitValues.contains(result.getExitValue())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unexpected exit value: ").append(result.getExitValue());
            sb.append(", allowed exit values: ").append(allowedExitValues);
            this.addExceptionMessageSuffix(sb, result.hasOutput() ? result.getOutput() : null);
            throw new InvalidExitValueException(sb.toString(), result);
        }
    }

    public void addExceptionMessageSuffix(StringBuilder sb) {
        this.addExceptionMessageSuffix(sb, this.getCurrentOutput());
    }

    private void addExceptionMessageSuffix(StringBuilder sb, ProcessOutput output) {
        sb.append(", executed command ").append(this.attributes.getCommand());
        if (this.attributes.getDirectory() != null) {
            sb.append(" in directory ").append(this.attributes.getDirectory());
        }
        if (!this.attributes.getEnvironment().isEmpty()) {
            sb.append(" with environment ").append(this.attributes.getEnvironment());
        }
        if (output != null) {
            int length = output.getBytes().length;
            String out = output.getString();
            if (out.length() <= 5000) {
                sb.append(", output was ").append(length).append(" bytes:\n").append(out.trim());
            } else {
                sb.append(", output was ").append(length).append(" bytes (truncated):\n");
                int halfLimit = 2500;
                sb.append(out.substring(0, halfLimit)).append("\n...\n").append(out.substring(out.length() - halfLimit).trim());
            }
        }
    }

    public StackTraceElement[] getStackTrace() {
        Thread t = this.workerThread;
        return t == null ? null : t.getStackTrace();
    }

    public String toString() {
        return this.process.toString();
    }
}

