/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.standard;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import org.springframework.util.StringUtils;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.standard.HttpServerHandler;
import org.yeauty.standard.ServerEndpointConfig;
import org.yeauty.util.SslUtils;

public class WebsocketServer {
    private final PojoEndpointServer pojoEndpointServer;
    private final ServerEndpointConfig config;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebsocketServer.class);

    public WebsocketServer(PojoEndpointServer webSocketServerHandler, ServerEndpointConfig serverEndpointConfig) {
        this.pojoEndpointServer = webSocketServerHandler;
        this.config = serverEndpointConfig;
    }

    public void init() throws InterruptedException, SSLException {
        ChannelFuture channelFuture;
        DefaultEventExecutorGroup eventExecutorGroup = null;
        final SslContext sslCtx = !StringUtils.isEmpty((Object)this.config.getKeyStore()) ? SslUtils.createSslContext(this.config.getKeyPassword(), this.config.getKeyStore(), this.config.getKeyStoreType(), this.config.getKeyStorePassword(), this.config.getTrustStore(), this.config.getTrustStoreType(), this.config.getTrustStorePassword()) : null;
        String[] corsOrigins = this.config.getCorsOrigins();
        Boolean corsAllowCredentials = this.config.getCorsAllowCredentials();
        final CorsConfig corsConfig = this.createCorsConfig(corsOrigins, corsAllowCredentials);
        if (this.config.isUseEventExecutorGroup()) {
            eventExecutorGroup = new DefaultEventExecutorGroup(this.config.getEventExecutorGroupThreads() == 0 ? 16 : this.config.getEventExecutorGroupThreads());
        }
        NioEventLoopGroup boss = new NioEventLoopGroup(this.config.getBossLoopGroupThreads());
        NioEventLoopGroup worker = new NioEventLoopGroup(this.config.getWorkerLoopGroupThreads());
        ServerBootstrap bootstrap = new ServerBootstrap();
        DefaultEventExecutorGroup finalEventExecutorGroup = eventExecutorGroup;
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)boss, (EventLoopGroup)worker).channel(NioServerSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.getConnectTimeoutMillis())).option(ChannelOption.SO_BACKLOG, (Object)this.config.getSoBacklog())).childOption(ChannelOption.WRITE_SPIN_COUNT, (Object)this.config.getWriteSpinCount()).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.config.getWriteBufferLowWaterMark(), this.config.getWriteBufferHighWaterMark())).childOption(ChannelOption.TCP_NODELAY, (Object)this.config.isTcpNodelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.config.isSoKeepalive()).childOption(ChannelOption.SO_LINGER, (Object)this.config.getSoLinger()).childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)this.config.isAllowHalfClosure()).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>((EventExecutorGroup)finalEventExecutorGroup){
            final /* synthetic */ EventExecutorGroup val$finalEventExecutorGroup;
            {
                this.val$finalEventExecutorGroup = eventExecutorGroup;
            }

            protected void initChannel(NioSocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslCtx != null) {
                    pipeline.addFirst(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                if (corsConfig != null) {
                    pipeline.addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpServerHandler(WebsocketServer.this.pojoEndpointServer, WebsocketServer.this.config, this.val$finalEventExecutorGroup, corsConfig != null)});
            }
        });
        if (this.config.getSoRcvbuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.config.getSoRcvbuf());
        }
        if (this.config.getSoSndbuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.config.getSoSndbuf());
        }
        if ("0.0.0.0".equals(this.config.getHost())) {
            channelFuture = bootstrap.bind(this.config.getPort());
        } else {
            try {
                channelFuture = bootstrap.bind((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.config.getHost()), this.config.getPort()));
            }
            catch (UnknownHostException e) {
                channelFuture = bootstrap.bind(this.config.getHost(), this.config.getPort());
                e.printStackTrace();
            }
        }
        channelFuture.addListener(future -> {
            if (!future.isSuccess()) {
                future.cause().printStackTrace();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> WebsocketServer.lambda$init$1((EventLoopGroup)boss, (EventLoopGroup)worker)));
    }

    private CorsConfig createCorsConfig(String[] corsOrigins, Boolean corsAllowCredentials) {
        if (corsOrigins.length == 0) {
            return null;
        }
        CorsConfigBuilder corsConfigBuilder = null;
        for (String corsOrigin : corsOrigins) {
            if (!"*".equals(corsOrigin)) continue;
            corsConfigBuilder = CorsConfigBuilder.forAnyOrigin();
            break;
        }
        if (corsConfigBuilder == null) {
            corsConfigBuilder = CorsConfigBuilder.forOrigins((String[])corsOrigins);
        }
        if (corsAllowCredentials != null && corsAllowCredentials.booleanValue()) {
            corsConfigBuilder.allowCredentials();
        }
        corsConfigBuilder.allowNullOrigin();
        return corsConfigBuilder.build();
    }

    public PojoEndpointServer getPojoEndpointServer() {
        return this.pojoEndpointServer;
    }

    private static /* synthetic */ void lambda$init$1(EventLoopGroup boss, EventLoopGroup worker) {
        boss.shutdownGracefully().syncUninterruptibly();
        worker.shutdownGracefully().syncUninterruptibly();
    }
}

