/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.custommonkey.xmlunit.DoctypeSupport;

public class DoctypeInputStream
extends InputStream {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    private final InputStream wrappedStream;
    private final DoctypeSupport support;

    public DoctypeInputStream(InputStream originalSource, String encoding, String doctypeName, String systemID) {
        this.wrappedStream = originalSource instanceof BufferedInputStream ? originalSource : new BufferedInputStream(originalSource);
        this.support = new DoctypeSupport(doctypeName, systemID, new DoctypeSupport.Readable(){

            @Override
            public int read() throws IOException {
                return DoctypeInputStream.this.wrappedStream.read();
            }
        }, false, encoding);
    }

    protected String getContent(String encoding) throws IOException {
        if (this.baos.size() == 0) {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = this.wrappedStream.read(buffer)) > -1) {
                this.baos.write(buffer, 0, bytesRead);
            }
        }
        return encoding == null ? this.baos.toString() : this.baos.toString(encoding);
    }

    @Override
    public int read() throws IOException {
        return this.support.read();
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }
}

