/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmatchers.validation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;
import org.xmlmatchers.transform.StringSource;

public class SchemaFactory {
    private static final String RELAX_NG_FACTORY_KEY = "javax.xml.validation.SchemaFactory:http://relaxng.org/ns/structure/1.0";
    private static final String DEFAULT_RELAX_NG_FACTORY = "org.iso_relax.verifier.jaxp.validation.RELAXNGSchemaFactoryImpl";

    private SchemaFactory() {
    }

    public static SchemaFactory newInstance(String language) {
        return null;
    }

    public Schema from(URL url) {
        return null;
    }

    public static Schema w3cXmlSchemaFromString(String schemaContents) throws SAXException {
        DOMSource source = StringSource.toSource(schemaContents);
        return SchemaFactory.schemaFrom(source, "http://www.w3.org/2001/XMLSchema");
    }

    public static Schema w3cXmlSchemaFromUrl(String urlString) throws SAXException, MalformedURLException {
        URL url = new URL(urlString);
        return SchemaFactory.w3cXmlSchemaFrom(url);
    }

    public static Schema w3cXmlSchemaFromClasspath(String resource) throws SAXException {
        URL url = SchemaFactory.classPathResourceToURL(resource);
        return SchemaFactory.w3cXmlSchemaFrom(url);
    }

    public static Schema w3cXmlSchemaFrom(File file) throws SAXException {
        return SchemaFactory.schemaFrom(file, "http://www.w3.org/2001/XMLSchema");
    }

    public static Schema w3cXmlSchemaFrom(URL url) throws SAXException {
        return SchemaFactory.schemaFrom(url, "http://www.w3.org/2001/XMLSchema");
    }

    public static Schema dtdSchemaFromClasspath(String resource) throws SAXException {
        URL url = SchemaFactory.classPathResourceToURL(resource);
        return SchemaFactory.dtdSchemaFrom(url);
    }

    public static Schema dtdSchemaFrom(URL url) throws SAXException {
        return SchemaFactory.schemaFrom(url, "http://www.w3.org/TR/REC-xml");
    }

    public static Schema relaxNGSchemaFromClasspath(String resource) throws SAXException {
        URL url = SchemaFactory.classPathResourceToURL(resource);
        return SchemaFactory.relaxNGSchemaFrom(url);
    }

    public static Schema relaxNGSchemaFrom(URL url) throws SAXException {
        if (System.getProperty(RELAX_NG_FACTORY_KEY) == null) {
            System.setProperty(RELAX_NG_FACTORY_KEY, DEFAULT_RELAX_NG_FACTORY);
        }
        return SchemaFactory.schemaFrom(url, "http://relaxng.org/ns/structure/1.0");
    }

    private static Schema schemaFrom(URL url, String schemaLanguage) throws SAXException {
        javax.xml.validation.SchemaFactory factory = javax.xml.validation.SchemaFactory.newInstance(schemaLanguage);
        return factory.newSchema(url);
    }

    private static Schema schemaFrom(File file, String schemaLanguage) throws SAXException {
        javax.xml.validation.SchemaFactory factory = javax.xml.validation.SchemaFactory.newInstance(schemaLanguage);
        return factory.newSchema(file);
    }

    private static Schema schemaFrom(Source source, String schemaLanguage) throws SAXException {
        javax.xml.validation.SchemaFactory factory = javax.xml.validation.SchemaFactory.newInstance(schemaLanguage);
        return factory.newSchema(source);
    }

    private static URL classPathResourceToURL(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }
}

