/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.interceptor.server;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.ejb3.interceptor.server.ServerInterceptorMetaData;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;

public class ClientInterceptorCache {
    private final List<ServerInterceptorMetaData> serverInterceptorMetaData;
    private List<Class<? extends EJBClientInterceptor>> clientInterceptors = null;

    public ClientInterceptorCache(List<ServerInterceptorMetaData> interceptorsMetaData) {
        this.serverInterceptorMetaData = interceptorsMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<? extends EJBClientInterceptor>> getClientInterceptors() {
        ClientInterceptorCache clientInterceptorCache = this;
        synchronized (clientInterceptorCache) {
            if (this.clientInterceptors == null) {
                this.loadClientInterceptors();
            }
        }
        return this.clientInterceptors;
    }

    private void loadClientInterceptors() {
        this.clientInterceptors = new ArrayList<Class<? extends EJBClientInterceptor>>();
        for (ServerInterceptorMetaData si : this.serverInterceptorMetaData) {
            String moduleId = si.getModule();
            try {
                Module module = Module.getCallerModuleLoader().loadModule(moduleId);
                this.clientInterceptors.add(ClassLoadingUtils.loadClass((String)si.getClazz(), (Module)module).asSubclass(EJBClientInterceptor.class));
            }
            catch (ModuleLoadException e) {
                throw EjbLogger.ROOT_LOGGER.cannotLoadServerInterceptorModule(moduleId, (Exception)((Object)e));
            }
            catch (ClassNotFoundException e) {
                throw EeLogger.ROOT_LOGGER.cannotLoadInterceptor((Throwable)e, si.getClazz());
            }
        }
    }
}

