/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.List;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.filter.PathFilters;

public class GlobalModuleDependencyProcessor
implements DeploymentUnitProcessor {
    private volatile List<GlobalModulesDefinition.GlobalModule> globalModules;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        List<GlobalModulesDefinition.GlobalModule> globalMods = this.globalModules;
        for (GlobalModulesDefinition.GlobalModule module : globalMods) {
            ModuleDependency dependency = new ModuleDependency(Module.getBootModuleLoader(), module.getModuleIdentifier(), false, false, module.isServices(), false);
            if (module.isMetaInf()) {
                dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
                dependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
            }
            if (module.isAnnotations()) {
                deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES, (Object)module.getModuleIdentifier());
            }
            moduleSpecification.addSystemDependency(dependency);
        }
    }

    public void setGlobalModules(List<GlobalModulesDefinition.GlobalModule> globalModules) {
        this.globalModules = globalModules;
    }
}

