/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.DelegatingSupplier;

public final class InjectedEENamespaceContextSelector
extends NamespaceContextSelector {
    private static final CompositeName EMPTY_NAME = new CompositeName();
    private final DelegatingSupplier<NamingStore> jbossContext = new DelegatingSupplier();
    private final DelegatingSupplier<NamingStore> globalContext = new DelegatingSupplier();
    private final DelegatingSupplier<NamingStore> appContext = new DelegatingSupplier();
    private final DelegatingSupplier<NamingStore> moduleContext = new DelegatingSupplier();
    private final DelegatingSupplier<NamingStore> compContext = new DelegatingSupplier();
    private final DelegatingSupplier<NamingStore> exportedContext = new DelegatingSupplier();

    public DelegatingSupplier<NamingStore> getAppContextSupplier() {
        return this.appContext;
    }

    public DelegatingSupplier<NamingStore> getModuleContextSupplier() {
        return this.moduleContext;
    }

    public DelegatingSupplier<NamingStore> getCompContextSupplier() {
        return this.compContext;
    }

    public DelegatingSupplier<NamingStore> getJbossContextSupplier() {
        return this.jbossContext;
    }

    public DelegatingSupplier<NamingStore> getGlobalContextSupplier() {
        return this.globalContext;
    }

    public DelegatingSupplier<NamingStore> getExportedContextSupplier() {
        return this.exportedContext;
    }

    private NamingStore getNamingStore(String identifier) {
        if (identifier.equals("jboss")) {
            return (NamingStore)this.jbossContext.get();
        }
        if (identifier.equals("global")) {
            return (NamingStore)this.globalContext.get();
        }
        if (identifier.equals("app")) {
            return (NamingStore)this.appContext.get();
        }
        if (identifier.equals("module")) {
            return (NamingStore)this.moduleContext.get();
        }
        if (identifier.equals("comp")) {
            return (NamingStore)this.compContext.get();
        }
        if (identifier.equals("jboss/exported")) {
            return (NamingStore)this.exportedContext.get();
        }
        return null;
    }

    public Context getContext(String identifier) {
        NamingStore namingStore = this.getNamingStore(identifier);
        if (namingStore != null) {
            try {
                return (Context)namingStore.lookup((Name)EMPTY_NAME);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

