/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RunResult;

public class ControlPointUtils {
    public static Runnable doWrap(Runnable runnable, ControlPoint controlPoint) {
        RunResult result;
        if (controlPoint == null || runnable == null) {
            return runnable;
        }
        try {
            result = controlPoint.forceBeginRequest();
        }
        catch (Exception e) {
            throw new RejectedExecutionException(e);
        }
        if (result == RunResult.REJECTED) {
            throw EeLogger.ROOT_LOGGER.rejectedDueToMaxRequests();
        }
        try {
            ControlledRunnable controlledRunnable = new ControlledRunnable(runnable, controlPoint);
            return runnable instanceof ManagedTask ? new ControlledManagedRunnable(controlledRunnable, (ManagedTask)runnable) : controlledRunnable;
        }
        catch (Exception e) {
            controlPoint.requestComplete();
            throw new RejectedExecutionException(e);
        }
    }

    public static <T> Callable<T> doWrap(Callable<T> callable, ControlPoint controlPoint) {
        RunResult result;
        if (controlPoint == null || callable == null) {
            return callable;
        }
        try {
            result = controlPoint.forceBeginRequest();
        }
        catch (Exception e) {
            throw new RejectedExecutionException(e);
        }
        if (result == RunResult.REJECTED) {
            throw EeLogger.ROOT_LOGGER.rejectedDueToMaxRequests();
        }
        try {
            ControlledCallable<T> controlledCallable = new ControlledCallable<T>(callable, controlPoint);
            return callable instanceof ManagedTask ? new ControlledManagedCallable<T>(controlledCallable, (ManagedTask)callable) : controlledCallable;
        }
        catch (Exception e) {
            controlPoint.requestComplete();
            throw new RejectedExecutionException(e);
        }
    }

    public static Runnable doScheduledWrap(Runnable runnable, ControlPoint controlPoint) {
        if (controlPoint == null || runnable == null) {
            return runnable;
        }
        ControlledScheduledRunnable controlledScheduledRunnable = new ControlledScheduledRunnable(runnable, controlPoint);
        return runnable instanceof ManagedTask ? new ControlledManagedRunnable(controlledScheduledRunnable, (ManagedTask)runnable) : controlledScheduledRunnable;
    }

    public static <T> Callable<T> doScheduledWrap(Callable<T> callable, ControlPoint controlPoint) {
        if (controlPoint == null || callable == null) {
            return callable;
        }
        ControlledScheduledCallable<T> controlledScheduledCallable = new ControlledScheduledCallable<T>(callable, controlPoint);
        return callable instanceof ManagedTask ? new ControlledManagedCallable<T>(controlledScheduledCallable, (ManagedTask)callable) : controlledScheduledCallable;
    }

    static class ControlledManagedTaskListener
    implements ManagedTaskListener {
        private final ManagedTaskListener managedTaskListener;

        ControlledManagedTaskListener(ManagedTaskListener managedTaskListener) {
            this.managedTaskListener = managedTaskListener;
        }

        public void taskAborted(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
            this.managedTaskListener.taskAborted(future, executor, (Object)((ControlledManagedTask)task).managedTask, exception);
        }

        public void taskDone(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
            this.managedTaskListener.taskDone(future, executor, (Object)((ControlledManagedTask)task).managedTask, exception);
        }

        public void taskStarting(Future<?> future, ManagedExecutorService executor, Object task) {
            this.managedTaskListener.taskStarting(future, executor, (Object)((ControlledManagedTask)task).managedTask);
        }

        public void taskSubmitted(Future<?> future, ManagedExecutorService executor, Object task) {
            this.managedTaskListener.taskSubmitted(future, executor, (Object)((ControlledManagedTask)task).managedTask);
        }
    }

    static class ControlledManagedCallable<T>
    extends ControlledManagedTask
    implements Callable<T> {
        private final Callable<T> controlledTask;

        ControlledManagedCallable(Callable<T> controlledTask, ManagedTask managedTask) {
            super(managedTask);
            this.controlledTask = controlledTask;
        }

        @Override
        public T call() throws Exception {
            return this.controlledTask.call();
        }
    }

    static class ControlledManagedRunnable
    extends ControlledManagedTask
    implements Runnable {
        private final Runnable controlledTask;

        ControlledManagedRunnable(Runnable controlledTask, ManagedTask managedTask) {
            super(managedTask);
            this.controlledTask = controlledTask;
        }

        @Override
        public void run() {
            this.controlledTask.run();
        }
    }

    static class ControlledManagedTask
    implements ManagedTask {
        private final ManagedTask managedTask;
        private final ControlledManagedTaskListener managedTaskListenerWrapper;

        ControlledManagedTask(ManagedTask managedTask) {
            this.managedTask = managedTask;
            this.managedTaskListenerWrapper = managedTask.getManagedTaskListener() != null ? new ControlledManagedTaskListener(managedTask.getManagedTaskListener()) : null;
        }

        public Map<String, String> getExecutionProperties() {
            return this.managedTask.getExecutionProperties();
        }

        public ManagedTaskListener getManagedTaskListener() {
            return this.managedTaskListenerWrapper;
        }
    }

    static class ControlledScheduledCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;
        private final ControlPoint controlPoint;

        ControlledScheduledCallable(Callable<T> callable, ControlPoint controlPoint) {
            this.callable = callable;
            this.controlPoint = controlPoint;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T call() throws Exception {
            if (this.controlPoint == null) {
                return this.callable.call();
            }
            try {
                if (this.controlPoint.beginRequest() != RunResult.RUN) throw EeLogger.ROOT_LOGGER.cannotRunScheduledTask(this.callable);
                try {
                    T t = this.callable.call();
                    return t;
                }
                finally {
                    this.controlPoint.requestComplete();
                }
            }
            catch (Exception e) {
                EeLogger.ROOT_LOGGER.failedToRunTask(e);
            }
            throw EeLogger.ROOT_LOGGER.cannotRunScheduledTask(this.callable);
        }
    }

    static class ControlledScheduledRunnable
    implements Runnable {
        private final Runnable runnable;
        private final ControlPoint controlPoint;

        ControlledScheduledRunnable(Runnable runnable, ControlPoint controlPoint) {
            this.runnable = runnable;
            this.controlPoint = controlPoint;
        }

        @Override
        public void run() {
            if (this.controlPoint == null) {
                this.runnable.run();
            } else {
                try {
                    if (this.controlPoint.beginRequest() == RunResult.RUN) {
                        try {
                            this.runnable.run();
                        }
                        finally {
                            this.controlPoint.requestComplete();
                        }
                        return;
                    }
                    throw EeLogger.ROOT_LOGGER.cannotRunScheduledTask(this.runnable);
                }
                catch (Exception e) {
                    EeLogger.ROOT_LOGGER.failedToRunTask(e);
                }
            }
        }
    }

    static class ControlledCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;
        private final ControlPoint controlPoint;

        ControlledCallable(Callable<T> callable, ControlPoint controlPoint) {
            this.callable = callable;
            this.controlPoint = controlPoint;
        }

        @Override
        public T call() throws Exception {
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                this.controlPoint.requestComplete();
            }
        }
    }

    static class ControlledRunnable
    implements Runnable {
        private final Runnable runnable;
        private final ControlPoint controlPoint;

        ControlledRunnable(Runnable runnable, ControlPoint controlPoint) {
            this.runnable = runnable;
            this.controlPoint = controlPoint;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                this.controlPoint.requestComplete();
            }
        }
    }
}

