/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import jakarta.json.JsonObjectBuilder;
import jakarta.json.spi.JsonProvider;
import java.security.Permission;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.event.SecurityAuthenticationFailedEvent;
import org.wildfly.security.auth.server.event.SecurityDefiniteOutcomeEvent;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckEvent;
import org.wildfly.security.auth.server.event.SecurityRealmUnavailableEvent;
import org.wildfly.security.auth.server.event.SyslogAuditEvent;

public class JsonSecurityEventFormatter
extends SecurityEventVisitor<Void, String> {
    private final Supplier<DateTimeFormatter> dateTimeFormatterSupplier;
    private final JsonProvider jsonProvider;

    JsonSecurityEventFormatter(Builder builder) {
        this.dateTimeFormatterSupplier = builder.dateTimeFormatterSupplier;
        this.jsonProvider = JsonProvider.provider();
    }

    @Override
    public String handleUnknownEvent(SecurityEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        JsonObjectBuilder objectBuilder = this.jsonProvider.createObjectBuilder();
        this.handleUnknownEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handleUnknownEvent(SecurityEvent event, JsonObjectBuilder objectBuilder) {
        DateTimeFormatter dateFormat = this.dateTimeFormatterSupplier.get();
        objectBuilder.add("event", event.getClass().getSimpleName());
        objectBuilder.add("event-time", dateFormat.format(event.getInstant()));
        JsonObjectBuilder securityIdentityBuilder = this.jsonProvider.createObjectBuilder();
        SecurityIdentity securityIdentity = event.getSecurityIdentity();
        securityIdentityBuilder.add("name", securityIdentity.getPrincipal().getName());
        securityIdentityBuilder.add("creation-time", dateFormat.format(securityIdentity.getCreationTime()));
        objectBuilder.add("security-identity", securityIdentityBuilder);
    }

    @Override
    public String handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        JsonObjectBuilder objectBuilder = this.jsonProvider.createObjectBuilder();
        this.handleDefiniteOutcomeEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, JsonObjectBuilder objectBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, objectBuilder);
        objectBuilder.add("success", event.isSuccessful());
    }

    @Override
    public String handleAuthenticationFailedEvent(SecurityAuthenticationFailedEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        JsonObjectBuilder objectBuilder = this.jsonProvider.createObjectBuilder();
        this.handleAuthenticationFailedEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handleAuthenticationFailedEvent(SecurityAuthenticationFailedEvent event, JsonObjectBuilder objectBuilder) {
        this.handleDefiniteOutcomeEvent((SecurityDefiniteOutcomeEvent)event, objectBuilder);
        if (event.getPrincipal() != null && event.getPrincipal().toString() != null) {
            objectBuilder.add("principal", event.getPrincipal().toString());
        } else {
            objectBuilder.addNull("principal");
        }
    }

    @Override
    public String handlePermissionCheckEvent(SecurityPermissionCheckEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        JsonObjectBuilder objectBuilder = this.jsonProvider.createObjectBuilder();
        this.handlePermissionCheckEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handlePermissionCheckEvent(SecurityPermissionCheckEvent event, JsonObjectBuilder objectBuilder) {
        this.handleDefiniteOutcomeEvent((SecurityDefiniteOutcomeEvent)event, objectBuilder);
        Permission permission = event.getPermission();
        JsonObjectBuilder permissionBuilder = this.jsonProvider.createObjectBuilder();
        permissionBuilder.add("type", permission.getClass().getName());
        permissionBuilder.add("actions", permission.getActions());
        permissionBuilder.add("name", permission.getName());
        objectBuilder.add("permission", permissionBuilder);
    }

    @Override
    public String handleSyslogAuditEvent(SyslogAuditEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        JsonObjectBuilder objectBuilder = this.jsonProvider.createObjectBuilder();
        this.handleSyslogAuditEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handleSyslogAuditEvent(SyslogAuditEvent event, JsonObjectBuilder objectBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, objectBuilder);
        objectBuilder.add("syslog-format", event.getFormat().toString());
    }

    @Override
    public String handleRealmUnavailableEvent(SecurityRealmUnavailableEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        JsonObjectBuilder objectBuilder = this.jsonProvider.createObjectBuilder();
        this.handleRealmUnavailableEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handleRealmUnavailableEvent(SecurityRealmUnavailableEvent event, JsonObjectBuilder objectBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, objectBuilder);
        objectBuilder.add("realm-name", event.getRealmName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());

        Builder() {
        }

        public Builder setDateTimeFormatterSupplier(Supplier<DateTimeFormatter> dateTimeFormatterSupplier) {
            this.dateTimeFormatterSupplier = (Supplier)Assert.checkNotNullParam((String)"dateTimeFormatterSupplier", dateTimeFormatterSupplier);
            return this;
        }

        public SecurityEventVisitor<?, String> build() {
            return new JsonSecurityEventFormatter(this);
        }
    }
}

