/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.ra;

import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveAdminObjectFromRA
implements OnlineCommand {
    private final String poolName;
    private final String resourceAdapterId;

    private RemoveAdminObjectFromRA(Builder builder) {
        this.poolName = builder.poolName;
        this.resourceAdapterId = builder.resourceAdapterId;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address address = Address.subsystem((String)"resource-adapters").and("resource-adapter", this.resourceAdapterId).and("admin-objects", this.poolName);
        ops.remove(address);
    }

    public String toString() {
        return "RemoveAdminObjectFromRA " + this.poolName;
    }

    public static final class Builder {
        private final String poolName;
        private final String resourceAdapterId;

        public Builder(String poolName, String resourceAdapterId) {
            this.poolName = poolName;
            this.resourceAdapterId = resourceAdapterId;
        }

        public RemoveAdminObjectFromRA build() {
            return new RemoveAdminObjectFromRA(this);
        }
    }
}

