/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.foundation.online;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import java.util.Iterator;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public final class CliScript
implements OnlineCommand {
    private final String script;
    private final String description;

    public CliScript(String script) {
        this(script, null);
    }

    CliScript(String script, String description) {
        if (script == null) {
            throw new IllegalArgumentException("The script text must be provided");
        }
        this.script = script;
        this.description = description;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Object lines = CharSource.wrap((CharSequence)this.script).readLines();
        if (Iterables.any((Iterable)(lines = Iterables.filter((Iterable)lines, (Predicate)Predicates.not((Predicate)Predicates.containsPattern((String)"^\\s*connect\\s*$")))), (Predicate)Predicates.containsPattern((String)"^\\s*connect"))) {
            throw new CommandFailedException("The script contains an unsupported 'connect' operation");
        }
        Iterator i$ = lines.iterator();
        while (i$.hasNext()) {
            String line = (String)i$.next();
            ctx.client.executeCli(line.trim());
        }
    }

    public String toString() {
        if (this.description == null) {
            return "CliScript";
        }
        return "CliScript " + this.description;
    }
}

