/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.singleobjective;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.impl.DefaultLocalSearch;
import org.uma.jmetal.algorithm.multiobjective.smpso.jmetal5version.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.jmetal5version.SMPSOBuilder;
import org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization.CoralReefsOptimization;
import org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization.CoralReefsOptimizationBuilder;
import org.uma.jmetal.algorithm.singleobjective.differentialevolution.DifferentialEvolution;
import org.uma.jmetal.algorithm.singleobjective.differentialevolution.DifferentialEvolutionBuilder;
import org.uma.jmetal.algorithm.singleobjective.evolutionstrategy.CovarianceMatrixAdaptationEvolutionStrategy;
import org.uma.jmetal.algorithm.singleobjective.evolutionstrategy.EvolutionStrategyBuilder;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GeneticAlgorithmBuilder;
import org.uma.jmetal.algorithm.singleobjective.particleswarmoptimization.StandardPSO2007;
import org.uma.jmetal.algorithm.singleobjective.particleswarmoptimization.StandardPSO2011;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.crossover.impl.SinglePointCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.operator.selection.impl.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.problem.singleobjective.Rosenbrock;
import org.uma.jmetal.problem.singleobjective.Sphere;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.MultithreadedSolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;
import org.uma.jmetal.util.pseudorandom.impl.MersenneTwisterGenerator;

public class SteadyStateGeneticAlgorithmBinaryEncodingRunner {
    public static void main(String[] args) throws Exception {
        OneMax problem = new OneMax(Integer.valueOf(1024));
        SinglePointCrossover crossover = new SinglePointCrossover(0.9);
        double mutationProbability = 1.0 / (double)problem.getBitsFromVariable(0);
        BitFlipMutation mutation = new BitFlipMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        Algorithm algorithm = new GeneticAlgorithmBuilder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation).setPopulationSize(50).setMaxEvaluations(25000).setSelectionOperator((SelectionOperator)selection).setVariant(GeneticAlgorithmBuilder.GeneticAlgorithmVariant.STEADY_STATE).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        long computingTime = algorithmRunner.getComputingTime();
        BinarySolution solution = (BinarySolution)algorithm.getResult();
        ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(1);
        population.add(solution);
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
        JMetalLogger.logger.info("Solution: " + solution.getVariable(0));
    }

    public static class StandardPSO2011Runner {
        private static final int DEFAULT_NUMBER_OF_CORES = 1;

        public static void main(String[] args) throws Exception {
            String problemName = "org.uma.jmetal.problem.singleobjective.Sphere";
            DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
            int numberOfCores = args.length == 1 ? Integer.valueOf(args[0]) : 1;
            Object evaluator = numberOfCores == 1 ? new SequentialSolutionListEvaluator() : new MultithreadedSolutionListEvaluator(numberOfCores);
            StandardPSO2011 algorithm = new StandardPSO2011(problem, 10 + (int)(2.0 * Math.sqrt(problem.getNumberOfVariables())), 25000, 3, (SolutionListEvaluator)evaluator);
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
            DoubleSolution solution = (DoubleSolution)algorithm.getResult();
            long computingTime = algorithmRunner.getComputingTime();
            ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
            population.add(solution);
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
            JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
            JMetalLogger.logger.info("Solution: " + solution.getVariable(0));
            evaluator.shutdown();
        }
    }

    public static class StandardPSO2007Runner {
        private static final int DEFAULT_NUMBER_OF_CORES = 1;

        public static void main(String[] args) throws Exception {
            String problemName = "org.uma.jmetal.problem.singleobjective.Sphere";
            DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
            int numberOfCores = args.length == 1 ? Integer.valueOf(args[0]) : 1;
            Object evaluator = numberOfCores == 1 ? new SequentialSolutionListEvaluator() : new MultithreadedSolutionListEvaluator(numberOfCores);
            StandardPSO2007 algorithm = new StandardPSO2007(problem, 10 + (int)(2.0 * Math.sqrt(problem.getNumberOfVariables())), 25000, 3, (SolutionListEvaluator)evaluator);
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
            DoubleSolution solution = (DoubleSolution)algorithm.getResult();
            long computingTime = algorithmRunner.getComputingTime();
            ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
            population.add(solution);
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
            JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
            JMetalLogger.logger.info("Solution: " + solution.getVariable(0));
            evaluator.shutdown();
        }
    }

    public static class SMPSORunner
    extends AbstractAlgorithmRunner {
        public static void main(String[] args) throws Exception {
            Rosenbrock problem = new Rosenbrock(Integer.valueOf(20));
            CrowdingDistanceArchive archive = new CrowdingDistanceArchive(100);
            double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
            double mutationDistributionIndex = 20.0;
            PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
            SMPSO algorithm = new SMPSOBuilder((DoubleProblem)problem, (BoundedArchive)archive).setMutation((MutationOperator)mutation).setMaxIterations(25).setSwarmSize(100).setRandomGenerator((PseudoRandomGenerator)new MersenneTwisterGenerator()).setSolutionListEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
            List population = (List)algorithm.getResult();
            long computingTime = algorithmRunner.getComputingTime();
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
            JMetalLogger.logger.info("Fitness: " + ((DoubleSolution)population.get(0)).getObjective(0));
        }
    }

    public static class ParallelGenerationalGeneticAlgorithmRunner {
        private static final int DEFAULT_NUMBER_OF_CORES = 0;

        public static void main(String[] args) throws Exception {
            OneMax problem = new OneMax(Integer.valueOf(512));
            int numberOfCores = args.length == 1 ? Integer.valueOf(args[0]) : 0;
            SinglePointCrossover crossoverOperator = new SinglePointCrossover(0.9);
            BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getBitsFromVariable(0));
            BinaryTournamentSelection selectionOperator = new BinaryTournamentSelection();
            GeneticAlgorithmBuilder builder = new GeneticAlgorithmBuilder((Problem)problem, (CrossoverOperator)crossoverOperator, (MutationOperator)mutationOperator).setPopulationSize(100).setMaxEvaluations(25000).setSelectionOperator((SelectionOperator)selectionOperator).setSolutionListEvaluator((SolutionListEvaluator)new MultithreadedSolutionListEvaluator(numberOfCores));
            Algorithm algorithm = builder.build();
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
            builder.getEvaluator().shutdown();
            BinarySolution solution = (BinarySolution)algorithm.getResult();
            ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(1);
            population.add(solution);
            long computingTime = algorithmRunner.getComputingTime();
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        }
    }

    public static class NonElitistEvolutionStrategyRunner {
        public static void main(String[] args) throws Exception {
            OneMax problem = new OneMax(Integer.valueOf(512));
            BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getBitsFromVariable(0));
            Algorithm algorithm = new EvolutionStrategyBuilder((Problem)problem, (MutationOperator)mutationOperator, EvolutionStrategyBuilder.EvolutionStrategyVariant.NON_ELITIST).setMaxEvaluations(25000).setMu(1).setLambda(10).build();
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
            BinarySolution solution = (BinarySolution)algorithm.getResult();
            ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(1);
            population.add(solution);
            long computingTime = algorithmRunner.getComputingTime();
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        }
    }

    public static class LocalSearchRunner {
        public static void main(String[] args) throws Exception {
            OneMax problem = new OneMax(Integer.valueOf(1024));
            BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getBitsFromVariable(0));
            int improvementRounds = 10000;
            DominanceComparator comparator = new DominanceComparator();
            DefaultLocalSearch localSearch = new DefaultLocalSearch(improvementRounds, (Problem)problem, (MutationOperator)mutationOperator, (Comparator)comparator);
            localSearch.run();
            BinarySolution newSolution = (BinarySolution)localSearch.getResult();
            JMetalLogger.logger.info("Fitness: " + newSolution.getObjective(0));
            JMetalLogger.logger.info("Solution: " + newSolution.getVariable(0));
        }
    }

    public static class ElitistEvolutionStrategyRunner {
        public static void main(String[] args) throws Exception {
            OneMax problem = new OneMax(Integer.valueOf(512));
            BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getBitsFromVariable(0));
            Algorithm algorithm = new EvolutionStrategyBuilder((Problem)problem, (MutationOperator)mutationOperator, EvolutionStrategyBuilder.EvolutionStrategyVariant.ELITIST).setMaxEvaluations(25000).setMu(1).setLambda(10).build();
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
            BinarySolution solution = (BinarySolution)algorithm.getResult();
            ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(1);
            population.add(solution);
            long computingTime = algorithmRunner.getComputingTime();
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        }
    }

    public static class DifferentialEvolutionRunner {
        private static final int DEFAULT_NUMBER_OF_CORES = 1;

        public static void main(String[] args) throws Exception {
            Sphere problem = new Sphere(Integer.valueOf(20));
            int numberOfCores = args.length == 1 ? Integer.valueOf(args[0]) : 1;
            Object evaluator = numberOfCores == 1 ? new SequentialSolutionListEvaluator() : new MultithreadedSolutionListEvaluator(numberOfCores);
            DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(0.5, 0.5, DifferentialEvolutionCrossover.DE_VARIANT.RAND_1_BIN);
            DifferentialEvolutionSelection selection = new DifferentialEvolutionSelection();
            DifferentialEvolution algorithm = new DifferentialEvolutionBuilder((DoubleProblem)problem).setCrossover(crossover).setSelection(selection).setSolutionListEvaluator((SolutionListEvaluator)evaluator).setMaxEvaluations(25000).setPopulationSize(100).build();
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
            DoubleSolution solution = (DoubleSolution)algorithm.getResult();
            long computingTime = algorithmRunner.getComputingTime();
            ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
            population.add(solution);
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
            JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
            evaluator.shutdown();
        }
    }

    public static class CovarianceMatrixAdaptationEvolutionStrategyRunner {
        public static void main(String[] args) throws Exception {
            Sphere problem = new Sphere();
            CovarianceMatrixAdaptationEvolutionStrategy algorithm = new CovarianceMatrixAdaptationEvolutionStrategy.Builder((DoubleProblem)problem).build();
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
            DoubleSolution solution = (DoubleSolution)algorithm.getResult();
            ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
            population.add(solution);
            long computingTime = algorithmRunner.getComputingTime();
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        }
    }

    public static class CoralReefsOptimizationRunner {
        public static void main(String[] args) throws Exception {
            OneMax problem = new OneMax(Integer.valueOf(512));
            SinglePointCrossover crossoverOperator = new SinglePointCrossover(0.9);
            BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getBitsFromVariable(0));
            BinaryTournamentSelection selectionOperator = new BinaryTournamentSelection();
            CoralReefsOptimization algorithm = new CoralReefsOptimizationBuilder((Problem)problem, (SelectionOperator)selectionOperator, (CrossoverOperator)crossoverOperator, (MutationOperator)mutationOperator).setM(10).setN(10).setRho(0.6).setFbs(0.9).setFbr(0.1).setFa(0.1).setPd(0.1).setAttemptsToSettle(3).setComparator((Comparator)new ObjectiveComparator(0)).build();
            AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
            List population = (List)algorithm.getResult();
            long computingTime = algorithmRunner.getComputingTime();
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
            JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
            JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
            JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        }
    }
}

