/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.evolutionstrategy.EvolutionStrategyBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class NonElitistEvolutionStrategyRunner {
    public static void main(String[] args) throws Exception {
        OneMax problem = new OneMax(Integer.valueOf(512));
        BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getBitsFromVariable(0));
        Algorithm algorithm = new EvolutionStrategyBuilder((Problem)problem, (MutationOperator)mutationOperator, EvolutionStrategyBuilder.EvolutionStrategyVariant.NON_ELITIST).setMaxEvaluations(25000).setMu(1).setLambda(10).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        BinarySolution solution = (BinarySolution)algorithm.getResult();
        ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(1);
        population.add(solution);
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

