/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.singleobjective;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GeneticAlgorithmBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.NullCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.CharSequenceRandomMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.singleobjective.StringMatching;
import org.uma.jmetal.solution.sequencesolution.impl.CharSequenceSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class GenerationalGeneticAlgorithmStringMatchingRunner {
    public static void main(String[] args) {
        StringMatching problem = new StringMatching("jMetal is an optimization framework");
        NullCrossover crossover = new NullCrossover();
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        CharSequenceRandomMutation mutation = new CharSequenceRandomMutation(mutationProbability, problem.getAlphabet());
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        Algorithm algorithm = new GeneticAlgorithmBuilder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation).setPopulationSize(50).setMaxEvaluations(250000).setSelectionOperator((SelectionOperator)selection).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        CharSequenceSolution solution = (CharSequenceSolution)algorithm.getResult();
        ArrayList<CharSequenceSolution> population = new ArrayList<CharSequenceSolution>(1);
        population.add(solution);
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Best found string: '" + solution.getVariables().stream().map(String::valueOf).collect(Collectors.joining()) + "'");
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

