/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GeneticAlgorithmBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.singleobjective.Sphere;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class GenerationalGeneticAlgorithmDoubleEncodingRunner {
    public static void main(String[] args) throws Exception {
        Sphere problem = new Sphere(Integer.valueOf(20));
        SBXCrossover crossover = new SBXCrossover(0.9, 20.0);
        PolynomialMutation mutation = new PolynomialMutation(1.0 / (double)problem.getNumberOfVariables(), 20.0);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        Algorithm algorithm = new GeneticAlgorithmBuilder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation).setPopulationSize(100).setMaxEvaluations(25000).setSelectionOperator((SelectionOperator)selection).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        DoubleSolution solution = (DoubleSolution)algorithm.getResult();
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
        population.add(solution);
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
    }
}

