/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.singleobjective;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization.CoralReefsOptimization;
import org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization.CoralReefsOptimizationBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SinglePointCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class CoralReefsOptimizationRunner {
    public static void main(String[] args) throws Exception {
        OneMax problem = new OneMax(Integer.valueOf(512));
        SinglePointCrossover crossoverOperator = new SinglePointCrossover(0.9);
        BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getBitsFromVariable(0));
        BinaryTournamentSelection selectionOperator = new BinaryTournamentSelection();
        CoralReefsOptimization algorithm = new CoralReefsOptimizationBuilder((Problem)problem, (SelectionOperator)selectionOperator, (CrossoverOperator)crossoverOperator, (MutationOperator)mutationOperator).setM(10).setN(10).setRho(0.6).setFbs(0.9).setFbr(0.1).setFa(0.1).setPd(0.1).setAttemptsToSettle(3).setComparator((Comparator)new ObjectiveComparator(0)).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

