/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.lab.visualization.plot.impl.PlotSmile;
import org.uma.jmetal.operator.crossover.impl.IntegerSBXCrossover;
import org.uma.jmetal.problem.integerproblem.IntegerProblem;
import org.uma.jmetal.problem.multiobjective.NMMin;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.IntegerVariableComparator;

public class IntegerSBXCrossoverExample {
    public static void main(String[] args) {
        double distributionIndex;
        int granularity;
        int numberOfPoints;
        if (args.length != 3) {
            JMetalLogger.logger.info("Usage: numberOfSolutions granularity distributionIndex");
            JMetalLogger.logger.info("Using default parameters");
            numberOfPoints = 10000;
            granularity = 100;
            distributionIndex = 10.0;
        } else {
            numberOfPoints = Integer.parseInt(args[0]);
            granularity = Integer.parseInt(args[1]);
            distributionIndex = Double.parseDouble(args[2]);
        }
        NMMin problem = new NMMin(1, -50, 50, -100, 100);
        IntegerSBXCrossover crossover = new IntegerSBXCrossover(1.0, distributionIndex);
        IntegerSolution solution1 = (IntegerSolution)problem.createSolution();
        IntegerSolution solution2 = (IntegerSolution)problem.createSolution();
        solution1.setVariable(0, (Object)-50);
        solution2.setVariable(0, (Object)50);
        List<IntegerSolution> parents = Arrays.asList(solution1, solution2);
        ArrayList<IntegerSolution> population = new ArrayList<IntegerSolution>(numberOfPoints);
        for (int i = 0; i < numberOfPoints; ++i) {
            List solutions = (List)crossover.execute(parents);
            population.add((IntegerSolution)solutions.get(0));
            population.add((IntegerSolution)solutions.get(1));
        }
        Collections.sort(population, new IntegerVariableComparator());
        double[][] classifier = IntegerSBXCrossoverExample.classify(population, (IntegerProblem)problem, granularity);
        PlotSmile plot = new PlotSmile(classifier);
        plot.plot();
    }

    private static double[][] classify(List<IntegerSolution> solutions, IntegerProblem problem, int granularity) {
        double grain = ((Integer)problem.getUpperBound(0) - (Integer)problem.getLowerBound(0)) / granularity;
        double[][] classifier = new double[granularity][];
        for (int i = 0; i < granularity; ++i) {
            classifier[i] = new double[2];
            classifier[i][0] = (double)((Integer)problem.getLowerBound(0)).intValue() + (double)i * grain;
            classifier[i][1] = 0.0;
        }
        for (IntegerSolution solution : solutions) {
            boolean found = false;
            int index = 0;
            while (!found) {
                if ((double)((Integer)solution.getVariable(0)).intValue() <= classifier[index][0]) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                if (index == granularity - 1) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                ++index;
            }
        }
        return classifier;
    }
}

