/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.spea2;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SinglePointCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.binaryproblem.BinaryProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;

public class SPEA2BinaryRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.OneZeroMax";
            referenceParetoFront = "";
        }
        BinaryProblem problem = (BinaryProblem)ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        SinglePointCrossover crossover = new SinglePointCrossover(crossoverProbability);
        double mutationProbability = 1.0 / (double)problem.getTotalNumberOfBits();
        BitFlipMutation mutation = new BitFlipMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        SPEA2 algorithm = new SPEA2Builder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation).setSelectionOperator((SelectionOperator)selection).setMaxIterations(250).setPopulationSize(100).build();
        new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        SPEA2BinaryRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            SPEA2BinaryRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

