/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.smpsorp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.smpso.jmetal5version.SMPSORP;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archivewithreferencepoint.ArchiveWithReferencePoint;
import org.uma.jmetal.util.archivewithreferencepoint.impl.CrowdingDistanceArchiveWithReferencePoint;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class SMPSORPWithMultipleReferencePointsRunner {
    public static void main(String[] args) throws JMetalException {
        String problemName = args.length == 1 ? args[0] : "org.uma.jmetal.problem.multiobjective.zdt.ZDT2";
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        ArrayList<List<Double>> referencePoints = new ArrayList<List<Double>>();
        referencePoints.add(Arrays.asList(0.2, 0.8));
        referencePoints.add(Arrays.asList(0.7, 0.4));
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int maxIterations = 250;
        int swarmSize = 100;
        ArrayList<CrowdingDistanceArchiveWithReferencePoint> archivesWithReferencePoints = new ArrayList<CrowdingDistanceArchiveWithReferencePoint>();
        for (int i = 0; i < referencePoints.size(); ++i) {
            archivesWithReferencePoints.add(new CrowdingDistanceArchiveWithReferencePoint(swarmSize / referencePoints.size(), (List)referencePoints.get(i)));
        }
        SMPSORP algorithm = new SMPSORP(problem, swarmSize, archivesWithReferencePoints, referencePoints, (MutationOperator)mutation, maxIterations, 0.0, 1.0, 0.0, 1.0, 2.5, 1.5, 2.5, 1.5, 0.1, 0.1, -1.0, -1.0, (SolutionListEvaluator)new SequentialSolutionListEvaluator());
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        for (int i = 0; i < archivesWithReferencePoints.size(); ++i) {
            new SolutionListOutput(((ArchiveWithReferencePoint)archivesWithReferencePoints.get(i)).getSolutionList()).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR" + i + ".tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN" + i + ".tsv")).print();
        }
        System.exit(0);
    }
}

