/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.nsgaii;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIMeasures;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.impl.ArrayFront;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.impl.BasicMeasure;
import org.uma.jmetal.util.measure.impl.DurationMeasure;

public class NSGAIIMeasuresWithQualityIndicatorRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, InterruptedException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "resources/referenceFrontsCSV/ZDT1.csv";
        }
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        int maxEvaluations = 25000;
        int populationSize = 100;
        NSGAII algorithm = new NSGAIIBuilder(problem, (CrossoverOperator)crossover, (MutationOperator)mutation, populationSize).setSelectionOperator((SelectionOperator)selection).setMaxEvaluations(maxEvaluations).setVariant(NSGAIIBuilder.NSGAIIVariant.Measures).build();
        ((NSGAIIMeasures)algorithm).setReferenceFront((Front)new ArrayFront(referenceParetoFront));
        MeasureManager measureManager = ((NSGAIIMeasures)algorithm).getMeasureManager();
        DurationMeasure currentComputingTime = (DurationMeasure)measureManager.getPullMeasure((Object)"currentExecutionTime");
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"currentPopulation");
        solutionListMeasure.register((MeasureListener)new Listener(referenceParetoFront));
        Thread algorithmThread = new Thread((Runnable)algorithm);
        algorithmThread.start();
        algorithmThread.join();
        List population = (List)algorithm.getResult();
        long computingTime = currentComputingTime.get();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        NSGAIIMeasuresWithQualityIndicatorRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            NSGAIIMeasuresWithQualityIndicatorRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }

    private static class Listener
    implements MeasureListener<List<DoubleSolution>> {
        private static int counter = 1;
        ArrayFront referenceParetoFront;

        public Listener(String referenceParetoFrontFile) throws FileNotFoundException {
            this.referenceParetoFront = new ArrayFront(referenceParetoFrontFile);
        }

        public synchronized void measureGenerated(List<DoubleSolution> solutionList) {
            Epsilon epsilon = new Epsilon((Front)this.referenceParetoFront);
            PISAHypervolume hv = new PISAHypervolume((Front)this.referenceParetoFront);
            System.out.println("Iteration: " + counter + ". Epsilon: " + epsilon.evaluate(solutionList) + ". Hypervolume: " + hv.evaluate(solutionList));
            ++counter;
        }
    }
}

