/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.nsgaii;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIMeasures;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.impl.BasicMeasure;
import org.uma.jmetal.util.measure.impl.CountingMeasure;
import org.uma.jmetal.util.measure.impl.DurationMeasure;

public class NSGAIIMeasuresRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, InterruptedException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "resources/referenceFrontsCSV/ZDT1.csv";
        }
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        int maxEvaluations = 25000;
        int populationSize = 100;
        NSGAII algorithm = new NSGAIIBuilder(problem, (CrossoverOperator)crossover, (MutationOperator)mutation, populationSize).setSelectionOperator((SelectionOperator)selection).setMaxEvaluations(maxEvaluations).setVariant(NSGAIIBuilder.NSGAIIVariant.Measures).build();
        MeasureManager measureManager = ((NSGAIIMeasures)algorithm).getMeasureManager();
        CountingMeasure currentEvalution = (CountingMeasure)measureManager.getPullMeasure((Object)"currentEvaluation");
        DurationMeasure currentComputingTime = (DurationMeasure)measureManager.getPullMeasure((Object)"currentExecutionTime");
        BasicMeasure nonDominatedSolutions = (BasicMeasure)measureManager.getPullMeasure((Object)"numberOfNonDominatedSolutionsInPopulation");
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"currentPopulation");
        CountingMeasure iteration2 = (CountingMeasure)measureManager.getPushMeasure((Object)"currentEvaluation");
        solutionListMeasure.register((MeasureListener)new Listener());
        iteration2.register((MeasureListener)new Listener2());
        Thread algorithmThread = new Thread((Runnable)algorithm);
        algorithmThread.start();
        int i = 0;
        while (currentEvalution.get() < (long)maxEvaluations) {
            TimeUnit.SECONDS.sleep(5L);
            System.out.println("Evaluations (" + i + ")                     : " + currentEvalution.get());
            System.out.println("Computing time (" + i + ")                  : " + currentComputingTime.get());
            System.out.println("Number of Nondominated solutions (" + i + "): " + nonDominatedSolutions.get());
            ++i;
        }
        algorithmThread.join();
        List population = (List)algorithm.getResult();
        long computingTime = currentComputingTime.get();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        NSGAIIMeasuresRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            NSGAIIMeasuresRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
        System.exit(0);
    }

    private static class Listener
    implements MeasureListener<List<DoubleSolution>> {
        private int counter = 0;

        private Listener() {
        }

        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            if (this.counter % 10 == 0) {
                System.out.println("PUSH MEASURE. Counter = " + this.counter + " First solution: " + solutions.get(0));
            }
            ++this.counter;
        }
    }

    private static class Listener2
    implements MeasureListener<Long> {
        private Listener2() {
        }

        public synchronized void measureGenerated(Long value) {
            if (value % 50L == 0L) {
                System.out.println("PUSH MEASURE. Iteration: " + value);
            }
        }
    }
}

