/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.nsgaii;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.doubleproblem.impl.ComposableDoubleProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;

public class NSGAIIComposableSchafferProblemRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, FileNotFoundException {
        String referenceParetoFront = "resources/referenceFrontsCSV/Schaffer.csv";
        ComposableDoubleProblem problem = new ComposableDoubleProblem().setName("Schaffer").addVariable(-10.0, 10.0).addVariable(-10.0, 10.0).addFunction(x -> x[0] * x[0]).addFunction(x -> (x[0] - 2.0) * (x[0] - 2.0));
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        NSGAII algorithm = new NSGAIIBuilder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation, 100).setSelectionOperator((SelectionOperator)selection).setMaxEvaluations(25000).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        NSGAIIComposableSchafferProblemRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            NSGAIIComposableSchafferProblemRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

