/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.moead;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;

public class MOEADDRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.UF.UF2";
            referenceParetoFront = "referenceFronts/UF2.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 1.0;
        double crossoverDistributionIndex = 30.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        MOEADBuilder builder = new MOEADBuilder((Problem)problem, MOEADBuilder.Variant.MOEADD);
        builder.setCrossover((CrossoverOperator)crossover).setMutation((MutationOperator)mutation).setMaxEvaluations(150000).setPopulationSize(300).setResultPopulationSize(300).setNeighborhoodSelectionProbability(0.9).setMaximumNumberOfReplacedSolutions(1).setNeighborSize(20).setFunctionType(AbstractMOEAD.FunctionType.PBI).setDataDirectory("MOEAD_Weights");
        AbstractMOEAD algorithm = builder.build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        MOEADDRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            MOEADDRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

