/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.moead;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;

public class MOEADDRARunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.lz09.LZ09F7";
            referenceParetoFront = "referenceFronts/LZ09_F2.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        double cr = 1.0;
        double f = 0.5;
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(cr, f, DifferentialEvolutionCrossover.DE_VARIANT.RAND_1_BIN);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        AbstractMOEAD algorithm = new MOEADBuilder((Problem)problem, MOEADBuilder.Variant.MOEADDRA).setCrossover((CrossoverOperator)crossover).setMutation((MutationOperator)mutation).setMaxEvaluations(175000).setPopulationSize(600).setResultPopulationSize(100).setNeighborhoodSelectionProbability(0.9).setMaximumNumberOfReplacedSolutions(2).setNeighborSize(20).setDataDirectory("MOEAD_Weights").setFunctionType(AbstractMOEAD.FunctionType.TCHE).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        MOEADDRARunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            MOEADDRARunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

