/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective.mocell;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.mocell.MOCell;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.neighborhood.impl.C9;

public class MOCellChangingMutationAndCrossoverProbabilitiesRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT4";
            referenceParetoFront = "resources/referenceFrontsCSV/ZDT4.csv";
        }
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        class MOCellWithChangesInVariationOperator
        extends MOCell<DoubleSolution> {
            public MOCellWithChangesInVariationOperator(Problem<DoubleSolution> problem, int maxEvaluations, int populationSize, BoundedArchive<DoubleSolution> archive, Neighborhood<DoubleSolution> neighborhood, CrossoverOperator<DoubleSolution> crossoverOperator, MutationOperator<DoubleSolution> mutationOperator, SelectionOperator<List<DoubleSolution>, DoubleSolution> selectionOperator, SolutionListEvaluator<DoubleSolution> evaluator) {
                super(problem, maxEvaluations, populationSize, archive, neighborhood, crossoverOperator, mutationOperator, selectionOperator, evaluator);
            }

            public void updateProgress() {
                super.updateProgress();
                if (this.evaluations > 10000) {
                    this.crossoverOperator = new SBXCrossover(0.7, 20.0);
                    this.mutationOperator = new PolynomialMutation(0.001, 30.0);
                }
            }
        }
        MOCellWithChangesInVariationOperator algorithm = new MOCellWithChangesInVariationOperator((Problem<DoubleSolution>)problem, 25000, 100, (BoundedArchive<DoubleSolution>)new CrowdingDistanceArchive(100), (Neighborhood<DoubleSolution>)new C9((int)Math.sqrt(100.0), (int)Math.sqrt(100.0)), (CrossoverOperator<DoubleSolution>)crossover, (MutationOperator<DoubleSolution>)mutation, (SelectionOperator<List<DoubleSolution>, DoubleSolution>)selection, (SolutionListEvaluator<DoubleSolution>)new SequentialSolutionListEvaluator());
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        MOCellChangingMutationAndCrossoverProbabilitiesRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            MOCellChangingMutationAndCrossoverProbabilitiesRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

