/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.omopso.OMOPSO;
import org.uma.jmetal.algorithm.multiobjective.omopso.OMOPSOBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.NonUniformMutation;
import org.uma.jmetal.operator.mutation.impl.UniformMutation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class OMOPSORunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "resources/referenceFrontsCSV/ZDT1.csv";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        OMOPSO algorithm = new OMOPSOBuilder(problem, (SolutionListEvaluator)new SequentialSolutionListEvaluator()).setMaxIterations(250).setSwarmSize(100).setUniformMutation((MutationOperator)new UniformMutation(mutationProbability, 0.5)).setNonUniformMutation((MutationOperator)new NonUniformMutation(mutationProbability, 0.5, 250)).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        OMOPSORunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            OMOPSORunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

