/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.NSGAIII;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.NSGAIIIBuilder;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.lab.visualization.plot.impl.Plot3D;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.front.impl.ArrayFront;

public class NSGAIIIRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException {
        String problemName = "org.uma.jmetal.problem.multiobjective.dtlz.DTLZ1";
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 30.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        NSGAIII algorithm = new NSGAIIIBuilder(problem).setCrossoverOperator((CrossoverOperator)crossover).setMutationOperator((MutationOperator)mutation).setSelectionOperator((SelectionOperator)selection).setMaxIterations(300).setNumberOfDivisions(12).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
        Plot3D plot = new Plot3D(new ArrayFront(population).getMatrix(), problem.getName() + " (NSGA-III)");
        plot.plot();
    }
}

