/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.dmopso.DMOPSO;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;

public class DMOPSORunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "resources/referenceFrontsCSV/ZDT1.csv";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        DMOPSO algorithm = new DMOPSO(problem, 100, 250, 0.0, 0.1, 0.0, 1.0, 1.5, 2.5, 1.5, 2.5, 0.1, 0.4, -1.0, -1.0, DMOPSO.FunctionType.TCHE, "MOEAD_Weights", 2);
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        DMOPSORunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            DMOPSORunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

