/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.example.multiobjective;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.cellde.CellDE45;
import org.uma.jmetal.example.AlgorithmRunner;
import org.uma.jmetal.operator.crossover.impl.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.neighborhood.impl.C9;

public class CellDERunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.dtlz.DTLZ1";
            referenceParetoFront = "resources/referenceFrontsCSV/DTLZ1.3D.csv";
        }
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double cr = 0.5;
        double f = 0.5;
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(cr, f, DifferentialEvolutionCrossover.DE_VARIANT.RAND_1_BIN);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        CellDE45 algorithm = new CellDE45(problem, 50000, 100, (BoundedArchive)new CrowdingDistanceArchive(100), (Neighborhood)new C9((int)Math.sqrt(100.0), (int)Math.sqrt(100.0)), (SelectionOperator)selection, crossover, 20.0, (SolutionListEvaluator)new SequentialSolutionListEvaluator());
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm<?>)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        CellDERunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            CellDERunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

