/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.services.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.util.Version;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.hibernate.HibernateGridDataSource;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.hibernate.SearchableHibernateGridDataSource;
import org.tynamo.search.SearchFilterPredicate;
import org.tynamo.services.SearchableGridDataSourceProvider;

public class SearchableHibernateGridDataSourceProvider
implements SearchableGridDataSourceProvider {
    private FullTextSession session;

    public SearchableHibernateGridDataSourceProvider(FullTextSession session) {
        this.session = session;
    }

    public GridDataSource createGridDataSource(Class entityType) {
        return new HibernateGridDataSource((Session)this.session, entityType);
    }

    public GridDataSource createGridDataSource(Class entityType, Set includedIds, Map<TynamoPropertyDescriptor, SearchFilterPredicate> propertySearchFilterMap) {
        return new SearchableHibernateGridDataSource((Session)this.session, entityType, propertySearchFilterMap);
    }

    public GridDataSource createGridDataSource(Class entityType, Map<TynamoPropertyDescriptor, SearchFilterPredicate> propertySearchFilterMap, List<TynamoPropertyDescriptor> searchablePropertyDescriptors, String searchString) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (TynamoPropertyDescriptor propertyDescriptor : searchablePropertyDescriptors) {
            fieldNames.add(propertyDescriptor.getName());
        }
        if (fieldNames.size() <= 0) {
            return this.createGridDataSource(entityType);
        }
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_35, fieldNames.toArray(new String[fieldNames.size()]), (Analyzer)new StandardAnalyzer(Version.LUCENE_35));
        try {
            return new SearchableHibernateGridDataSource((Session)this.session, entityType, this.session.createFullTextQuery(parser.parse(searchString), new Class[]{entityType}), propertySearchFilterMap);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

