/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.services;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.hibernate.HibernateGridDataSource;
import org.apache.tapestry5.hibernate.HibernateSessionManager;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PropertyConduitSource;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.tynamo.descriptor.CollectionDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.hibernate.QueryParameter;
import org.tynamo.hibernate.services.HibernatePersistenceService;
import org.tynamo.internal.services.GenericPersistenceService;
import org.tynamo.services.DescriptorService;

public class HibernatePersistenceServiceImpl
extends GenericPersistenceService
implements HibernatePersistenceService {
    private Logger logger;
    private DescriptorService descriptorService;
    private HibernateSessionManager sessionManager;
    private PropertyConduitSource propertyConduitSource;

    public HibernatePersistenceServiceImpl(Logger logger, DescriptorService descriptorService, HibernateSessionManager sessionManager, PropertyAccess propertyAccess, PropertyConduitSource propertyConduitSource) {
        super(propertyAccess);
        this.logger = logger;
        this.descriptorService = descriptorService;
        this.propertyConduitSource = propertyConduitSource;
        this.sessionManager = sessionManager;
    }

    private Session getSession() {
        return this.sessionManager.getSession();
    }

    @Override
    public <T> T getInstance(Class<T> type, DetachedCriteria detachedCriteria) {
        DetachedCriteria criteria = this.alterCriteria(type, detachedCriteria);
        return (T)criteria.getExecutableCriteria(this.getSession()).uniqueResult();
    }

    public <T> T getInstance(Class<T> type, Serializable id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(type).add(Restrictions.idEq((Object)id));
        return this.getInstance(type, criteria);
    }

    @Override
    public List findByQuery(String queryString) {
        return this.findByQuery(queryString, new QueryParameter[0]);
    }

    @Override
    public List findByQuery(String queryString, QueryParameter ... parameters) {
        return this.findByQuery(queryString, 0, 0, parameters);
    }

    @Override
    public List findByQuery(String queryString, int startIndex, int maxResults, QueryParameter ... parameters) {
        Query query = this.getSession().createQuery(queryString);
        for (QueryParameter parameter : parameters) {
            parameter.applyNamedParameterToQuery(query);
        }
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        if (startIndex > 0) {
            query.setFirstResult(startIndex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(query.getQueryString());
        }
        return query.list();
    }

    public <T> List<T> getInstances(Class<T> type) {
        return this.getSession().createCriteria(type).list();
    }

    public <T> List<T> getInstances(Class<T> type, int startIndex, int maxResults) {
        return this.getInstances(type, DetachedCriteria.forClass(type), startIndex, maxResults);
    }

    public <T> T save(T instance) {
        TynamoClassDescriptor tynamoclassdescriptor = this.descriptorService.getClassDescriptor(instance.getClass());
        if (!tynamoclassdescriptor.getHasCyclicRelationships() || this.isTransient(instance, tynamoclassdescriptor)) {
            this.getSession().saveOrUpdate(instance);
        } else {
            instance = this.getSession().merge(instance);
        }
        return instance;
    }

    public void removeAll(Collection collection) {
    }

    public void remove(Object instance) {
        this.getSession().delete(instance);
    }

    @Override
    public <T> List<T> getInstances(Class<T> type, DetachedCriteria criteria) {
        criteria = this.alterCriteria(type, criteria);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.getExecutableCriteria(this.getSession()).list();
    }

    @Override
    public void reattach(Object model) {
        this.getSession().lock(model, LockMode.NONE);
    }

    public Serializable getIdentifier(Object data, TynamoClassDescriptor classDescriptor) {
        return (Serializable)this.getPropertyAccess().get(data, classDescriptor.getIdentifierDescriptor().getName());
    }

    public Serializable getIdentifier(Object data) {
        return this.getIdentifier(data, this.descriptorService.getClassDescriptor(data.getClass()));
    }

    @Override
    public boolean isTransient(Object data, TynamoClassDescriptor classDescriptor) {
        try {
            return this.getIdentifier(data, classDescriptor) == null;
        }
        catch (TransientObjectException e) {
            return true;
        }
    }

    public List getInstances(Object example, TynamoClassDescriptor classDescriptor) {
        DetachedCriteria searchCriteria = DetachedCriteria.forClass(example.getClass());
        searchCriteria = this.alterCriteria(example.getClass(), searchCriteria);
        for (TynamoPropertyDescriptor propertyDescriptor : classDescriptor.getPropertyDescriptors()) {
            CollectionDescriptor collectionDescriptor;
            TynamoClassDescriptor collectionClassDescriptor;
            if (!propertyDescriptor.isSearchable()) continue;
            String propertyName = propertyDescriptor.getName();
            Class propertyClass = propertyDescriptor.getPropertyType();
            Object value = this.getPropertyAccess().get(example, propertyName);
            if (value == null) continue;
            if (String.class.isAssignableFrom(propertyClass) && ((String)value).length() > 0) {
                searchCriteria.add((Criterion)Restrictions.like((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.ANYWHERE));
                continue;
            }
            if (propertyDescriptor.isObjectReference()) {
                Serializable identifierValue = this.getIdentifier(value, this.descriptorService.getClassDescriptor(propertyDescriptor.getBeanType()));
                searchCriteria.createCriteria(propertyName).add(Restrictions.idEq((Object)identifierValue));
                continue;
            }
            if (propertyClass.isPrimitive()) {
                if (propertyClass.equals(Boolean.TYPE) || ((Number)value).longValue() == 0L) continue;
                searchCriteria.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
                continue;
            }
            if (!propertyDescriptor.isCollection() || (collectionClassDescriptor = this.descriptorService.getClassDescriptor((collectionDescriptor = (CollectionDescriptor)propertyDescriptor).getElementType())) == null) continue;
            String identifierName = collectionClassDescriptor.getIdentifierDescriptor().getName();
            ArrayList<Serializable> identifierValues = new ArrayList<Serializable>();
            Collection associatedItems = (Collection)value;
            if (associatedItems == null || associatedItems.size() <= 0) continue;
            for (Object o : associatedItems) {
                identifierValues.add(this.getIdentifier(o, collectionClassDescriptor));
            }
            searchCriteria.createCriteria(propertyName).add(Restrictions.in((String)identifierName, identifierValues));
        }
        searchCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return searchCriteria.getExecutableCriteria(this.getSession()).list();
    }

    public int count(Class type) {
        return this.count(type, DetachedCriteria.forClass((Class)type));
    }

    @Override
    public int count(Class type, DetachedCriteria detachedCriteria) {
        detachedCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        DetachedCriteria criteria = this.alterCriteria(type, detachedCriteria);
        Criteria executableCriteria = criteria.getExecutableCriteria(this.getSession()).setProjection(Projections.rowCount());
        return ((Long)executableCriteria.uniqueResult()).intValue();
    }

    @Override
    public <T> List<T> getInstances(Class<T> type, DetachedCriteria detachedCriteria, int startIndex, int maxResults) {
        return this.getInstances(this.alterCriteria(type, detachedCriteria), startIndex, maxResults);
    }

    public List getInstances(DetachedCriteria detachedCriteria, int startIndex, int maxResults) {
        detachedCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        Criteria executableCriteria = detachedCriteria.getExecutableCriteria(this.getSession());
        if (startIndex >= 0) {
            executableCriteria.setFirstResult(startIndex);
        }
        if (maxResults > 0) {
            executableCriteria.setMaxResults(maxResults);
        }
        return executableCriteria.list();
    }

    protected DetachedCriteria alterCriteria(Class type, DetachedCriteria detachedCriteria) {
        return detachedCriteria;
    }

    @Override
    public <T> T merge(T instance) {
        return (T)this.getSession().merge(instance);
    }

    @Override
    public <T> T saveOrUpdate(T instance) {
        this.getSession().saveOrUpdate(instance);
        return instance;
    }

    @Override
    public <T> T addToCollection(CollectionDescriptor descriptor, T element, Object collectionOwner) {
        Class elementType = descriptor.getElementType();
        String addMethod = descriptor.getAddExpression() != null ? descriptor.getAddExpression() : "add" + elementType.getSimpleName();
        try {
            Method method = descriptor.getBeanType().getMethod(addMethod, elementType);
            method.invoke(collectionOwner, element);
            return element;
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Collection collection = (Collection)this.getPropertyAccess().get(collectionOwner, descriptor.getName());
        if (!(descriptor.isChildRelationship() && collection instanceof List && collection.contains(element))) {
            collection.add(element);
        }
        return element;
    }

    public List getOrphanInstances(CollectionDescriptor descriptor, Object owner) {
        if (descriptor.getInverseProperty() != null && descriptor.isOneToMany()) {
            Criteria criteria = this.getSession().createCriteria(descriptor.getElementType());
            TynamoClassDescriptor elementDescriptor = this.descriptorService.getClassDescriptor(descriptor.getBeanType());
            String idProperty = elementDescriptor.getIdentifierDescriptor().getName();
            if (owner != null) {
                criteria.add((Criterion)Restrictions.disjunction().add(Restrictions.isNull((String)descriptor.getInverseProperty())).add((Criterion)Restrictions.eq((String)(descriptor.getInverseProperty() + "." + idProperty), (Object)this.getIdentifier(owner, elementDescriptor))));
            } else {
                criteria.add(Restrictions.isNull((String)descriptor.getInverseProperty()));
            }
            return criteria.list();
        }
        return this.getInstances(descriptor.getElementType());
    }

    public <T> GridDataSource getGridDataSource(Class<T> type) {
        return new HibernateGridDataSource(this.getSession(), type);
    }
}

