/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.tinylog.Level;
import org.tinylog.configuration.EnvironmentVariableResolver;
import org.tinylog.configuration.Resolver;
import org.tinylog.configuration.SystemPropertyResolver;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.RuntimeProvider;

public final class Configuration {
    private static final int MAX_LOCALE_ARGUMENTS = 3;
    private static final String[] CONFIGURATION_FILES = new String[]{"tinylog-dev.properties", "tinylog-test.properties", "tinylog.properties"};
    private static final String PROPERTIES_PREFIX = "tinylog.";
    private static final String CONFIGURATION_PROPERTY = "tinylog.configuration";
    private static final String LOCALE_KEY = "locale";
    private static final String ESCAPING_ENABLED_KEY = "escaping.enabled";
    private static final Pattern URL_DETECTION_PATTERN = Pattern.compile("^[a-zA-Z]{2,}:/.*");
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Properties properties = Configuration.load();
    private static boolean frozen;

    private Configuration() {
    }

    public static Locale getLocale() {
        String tag = Configuration.get(LOCALE_KEY);
        if (tag == null) {
            return Locale.ROOT;
        }
        String[] splitTag = tag.split("_", 3);
        if (splitTag.length == 1) {
            return new Locale(splitTag[0]);
        }
        if (splitTag.length == 2) {
            return new Locale(splitTag[0], splitTag[1]);
        }
        return new Locale(splitTag[0], splitTag[1], splitTag[2]);
    }

    public static boolean isEscapingEnabled() {
        return Boolean.parseBoolean(Configuration.get(ESCAPING_ENABLED_KEY));
    }

    public static String get(String key) {
        try {
            lock.readLock().lock();
            frozen = true;
            String string = (String)properties.get(key);
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getSiblings(String prefix) {
        try {
            lock.readLock().lock();
            frozen = true;
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.startsWith(prefix) || !prefix.endsWith("@") && key.indexOf(46, prefix.length()) != -1) continue;
                map.put(key, (String)properties.get(key));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getChildren(String key) {
        try {
            lock.readLock().lock();
            frozen = true;
            String prefix = key + ".";
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String property = (String)enumeration.nextElement();
                if (!property.startsWith(prefix)) continue;
                map.put(property.substring(prefix.length()), (String)properties.get(property));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void set(String key, String value) throws UnsupportedOperationException {
        try {
            lock.writeLock().lock();
            if (frozen) {
                throw new UnsupportedOperationException("Configuration cannot be changed after applying to tinylog");
            }
            properties.put(key, value);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void replace(Map<String, String> configuration) throws UnsupportedOperationException {
        try {
            lock.writeLock().lock();
            if (frozen) {
                throw new UnsupportedOperationException("Configuration cannot be changed after applying to tinylog");
            }
            properties.clear();
            properties.putAll(configuration);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static Properties load() {
        Properties properties;
        block9: {
            properties = new Properties();
            String file = System.getProperty(CONFIGURATION_PROPERTY);
            try {
                Object stream;
                if (file != null) {
                    if (URL_DETECTION_PATTERN.matcher(file).matches()) {
                        stream = new URL(file).openStream();
                    } else {
                        stream = RuntimeProvider.getClassLoader().getResourceAsStream(file);
                        if (stream == null) {
                            stream = new FileInputStream(file);
                        }
                    }
                    Configuration.load(properties, (InputStream)stream);
                    break block9;
                }
                stream = CONFIGURATION_FILES;
                int n = ((String[])stream).length;
                for (int i = 0; i < n; ++i) {
                    String configurationFile;
                    file = configurationFile = stream[i];
                    InputStream stream2 = RuntimeProvider.getClassLoader().getResourceAsStream(file);
                    if (stream2 == null) continue;
                    Configuration.load(properties, stream2);
                    break;
                }
            }
            catch (IOException ex) {
                InternalLogger.log(Level.ERROR, "Failed loading configuration from '" + file + "'");
            }
        }
        for (Object object : new ArrayList<Object>(System.getProperties().keySet())) {
            String name = (String)object;
            if (!name.startsWith(PROPERTIES_PREFIX)) continue;
            properties.put(name.substring(PROPERTIES_PREFIX.length()), System.getProperty(name));
        }
        for (Map.Entry entry : properties.entrySet()) {
            String value = (String)entry.getValue();
            if (value.indexOf(123) == -1) continue;
            value = Configuration.resolve(value, EnvironmentVariableResolver.INSTANCE);
            value = Configuration.resolve(value, SystemPropertyResolver.INSTANCE);
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    private static void load(Properties properties, InputStream stream) throws IOException {
        try {
            properties.load(stream);
        }
        finally {
            stream.close();
        }
    }

    private static String resolve(String value, Resolver resolver) {
        StringBuilder builder = new StringBuilder();
        int position = 0;
        String prefix = resolver.getPrefix() + "{";
        String postfix = "}";
        int index = value.indexOf(prefix);
        while (index != -1) {
            builder.append(value, position, index);
            int start = index + 2;
            int end = value.indexOf(postfix, start);
            if (end == -1) {
                InternalLogger.log(Level.WARN, "Closing curly bracket is missing for '" + value + "'");
                return value;
            }
            String name = value.substring(start, end);
            if (name.length() == 0) {
                InternalLogger.log(Level.WARN, "Empty variable names cannot be resolved: " + value);
                return value;
            }
            String[] colonSplittedName = name.split(":", -1);
            if (colonSplittedName.length > 2) {
                InternalLogger.log(Level.WARN, "Multiple default values found: " + value);
                return value;
            }
            String key = colonSplittedName[0];
            String defaultValue = colonSplittedName.length == 2 ? colonSplittedName[1] : null;
            String data = resolver.resolve(key);
            if (data == null) {
                if (defaultValue == null) {
                    InternalLogger.log(Level.WARN, "'" + key + "' could not be found in " + resolver.getName());
                    return value;
                }
                data = defaultValue;
            }
            builder.append(data);
            position = end + 1;
            index = value.indexOf(prefix, position);
        }
        builder.append(value, position, value.length());
        return builder.toString();
    }

    public static boolean isFrozen() {
        return frozen;
    }
}

