/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import springfox.documentation.spring.web.json.JacksonModuleRegistrar;
import springfox.documentation.spring.web.json.Json;

public class JsonSerializer {
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializer(List<JacksonModuleRegistrar> modules) {
        for (JacksonModuleRegistrar each : modules) {
            each.maybeRegisterModule(this.objectMapper);
        }
    }

    public Json toJson(Object toSerialize) {
        try {
            return new Json(this.objectMapper.writeValueAsString(toSerialize));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not write JSON", e);
        }
    }

    public <T> T fromJson(Json json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json.value(), clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not transform string JSON to object", e);
        }
    }
}

