/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ssssssss.script.functions.ObjectConvertExtension;

public class ClassScanner {
    public static List<String> scan() throws URISyntaxException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet<String> classes = new HashSet<String>();
        do {
            if (!(loader instanceof URLClassLoader)) continue;
            classes.addAll(ClassScanner.scan(((URLClassLoader)loader).getURLs()));
        } while ((loader = loader.getParent()) != null);
        classes.addAll(ClassScanner.addJavaLibrary());
        return new ArrayList<String>(classes);
    }

    private static Set<String> scan(URL[] urls) throws URISyntaxException {
        HashSet<String> classes = new HashSet<String>();
        if (urls != null) {
            for (URL url : urls) {
                String protocol = url.getProtocol();
                if ("file".equalsIgnoreCase(protocol)) {
                    String path = url.getPath();
                    if (path.toLowerCase().endsWith(".jar")) {
                        classes.addAll(ClassScanner.scanJarFile(url));
                        continue;
                    }
                    classes.addAll(ClassScanner.scanDirectory(new File(url.toURI()), null));
                    continue;
                }
                if (!"jar".equalsIgnoreCase(protocol)) continue;
                classes.addAll(ClassScanner.scanJarFile(url));
            }
        }
        return classes;
    }

    private static Set<String> addJavaLibrary() {
        int version = ClassScanner.checkJavaVersion();
        if (version >= 9) {
            return ClassScanner.addJava9PlusLibrary();
        }
        return ClassScanner.addJava8Library();
    }

    private static int checkJavaVersion() {
        String version = System.getProperty("java.version");
        int index = version.indexOf(".");
        if (index > -1) {
            String first = version.substring(0, index);
            if (!"1".equals(first)) {
                return ObjectConvertExtension.asInt((Object)first, (int)-1);
            }
            int endIndex = version.indexOf(".", index + 1);
            return ObjectConvertExtension.asInt((Object)version.substring(index + 1, endIndex), (int)-1);
        }
        return -1;
    }

    private static Set<String> addJava8Library() {
        try {
            Object URLClassPath = Class.forName("sun.misc.Launcher").getMethod("getBootstrapClassPath", new Class[0]).invoke(null, new Object[0]);
            return ClassScanner.scan((URL[])URLClassPath.getClass().getMethod("getURLs", new Class[0]).invoke(URLClassPath, new Object[0]));
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    private static Set<String> addJava9PlusLibrary() {
        HashSet<String> classes = new HashSet<String>();
        try {
            Class<?> ModuleLayer2 = Class.forName("java.lang.ModuleLayer");
            Object boot = ModuleLayer2.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            Object configuration = ModuleLayer2.getMethod("configuration", new Class[0]).invoke(boot, new Object[0]);
            Class<?> Configuration2 = Class.forName("java.lang.module.Configuration");
            Set modules = (Set)Configuration2.getMethod("modules", new Class[0]).invoke(configuration, new Object[0]);
            Method reference = Class.forName("java.lang.module.ResolvedModule").getMethod("reference", new Class[0]);
            Class<?> ModuleReader = Class.forName("java.lang.module.ModuleReader");
            Method open = Class.forName("java.lang.module.ModuleReference").getMethod("open", new Class[0]);
            Method list = ModuleReader.getMethod("list", new Class[0]);
            modules.forEach(module -> {});
            for (Object module2 : modules) {
                Object ref = reference.invoke(module2, new Object[0]);
                try {
                    Closeable reader = (Closeable)open.invoke(ref, new Object[0]);
                    Throwable throwable = null;
                    try {
                        Stream stream = (Stream)list.invoke((Object)reader, new Object[0]);
                        stream.filter(ClassScanner::isClass).forEach(className -> classes.add(className.substring(0, className.length() - 6).replace("/", ".")));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    private static List<String> scanDirectory(File dir, String packageName) {
        File[] files = dir.listFiles();
        ArrayList<String> classes = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (file.isDirectory()) {
                    classes.addAll(ClassScanner.scanDirectory(file, packageName == null ? name : packageName + "." + name));
                    continue;
                }
                if (!name.endsWith(".class") || name.contains("$")) continue;
                classes.add(ClassScanner.filterFullName(packageName + "." + name.substring(0, name.length() - 6)));
            }
        }
        return classes;
    }

    private static String filterFullName(String fullName) {
        if (fullName.startsWith("BOOT-INF.classes.")) {
            fullName = fullName.substring(17);
        }
        return fullName;
    }

    private static List<String> scanJarFile(URL url) {
        ArrayList<String> classes = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(url.openStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String className;
                if (entry.getName().contains("META-INF") || !ClassScanner.isClass(className = entry.getName())) continue;
                classes.add(ClassScanner.filterFullName(className.substring(0, className.length() - 6).replace("/", ".")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }

    private static boolean isClass(String className) {
        return className.endsWith(".class") && !className.contains("$");
    }
}

