/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.ssssssss.magicapi.config.MagicFunctionManager;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.exception.MagicServiceException;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.JsonCodeConstants;
import org.ssssssss.magicapi.model.RequestEntity;
import org.ssssssss.magicapi.model.TreeNode;
import org.ssssssss.magicapi.provider.ApiServiceProvider;
import org.ssssssss.magicapi.provider.FunctionServiceProvider;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.magicapi.script.ScriptManager;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;

public class DefaultMagicAPIService
implements MagicAPIService,
JsonCodeConstants {
    private final MappingHandlerMapping mappingHandlerMapping;
    private final boolean throwException;
    private final ResultProvider resultProvider;
    private final ApiServiceProvider apiServiceProvider;
    private final FunctionServiceProvider functionServiceProvider;
    private final GroupServiceProvider groupServiceProvider;
    private final MagicFunctionManager magicFunctionManager;

    public DefaultMagicAPIService(MappingHandlerMapping mappingHandlerMapping, ApiServiceProvider apiServiceProvider, FunctionServiceProvider functionServiceProvider, GroupServiceProvider groupServiceProvider, ResultProvider resultProvider, MagicFunctionManager magicFunctionManager, boolean throwException) {
        this.mappingHandlerMapping = mappingHandlerMapping;
        this.apiServiceProvider = apiServiceProvider;
        this.functionServiceProvider = functionServiceProvider;
        this.groupServiceProvider = groupServiceProvider;
        this.resultProvider = resultProvider;
        this.magicFunctionManager = magicFunctionManager;
        this.throwException = throwException;
        MagicResourceLoader.addFunctionLoader(name -> {
            String path;
            String method;
            ApiInfo info;
            int index = name.indexOf(":");
            if (index > -1 && (info = this.mappingHandlerMapping.getApiInfo(method = name.substring(0, index), path = name.substring(index + 1))) != null) {
                return new Expression(new Span("unknown source")){

                    public Object evaluate(MagicScriptContext context, Scope scope) {
                        return DefaultMagicAPIService.this.execute(info, scope.getVariables());
                    }
                };
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(ApiInfo info, Map<String, Object> context) {
        Object evalVal;
        MagicScriptContext magicScriptContext = MagicScriptContext.get();
        MagicScriptContext scriptContext = new MagicScriptContext();
        scriptContext.putMapIntoContext(context);
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute("ROOT", scriptContext, 100);
        try {
            evalVal = ((MagicScript)ScriptManager.compile("MagicScript", info.getScript())).eval((ScriptContext)simpleScriptContext);
        }
        finally {
            MagicScriptContext.set((MagicScriptContext)magicScriptContext);
        }
        return evalVal;
    }

    @Override
    public Object execute(String method, String path, Map<String, Object> context) {
        ApiInfo info = this.mappingHandlerMapping.getApiInfo(method, path);
        if (info == null) {
            throw new MagicServiceException(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u63a5\u53e3 [%s:%s]", method, path));
        }
        return this.execute(info, context);
    }

    @Override
    public Object call(String method, String path, Map<String, Object> context) {
        RequestEntity requestEntity = RequestEntity.empty();
        try {
            return this.resultProvider.buildResult(requestEntity, this.execute(method, path, context));
        }
        catch (MagicServiceException e) {
            return null;
        }
        catch (Throwable root) {
            if (this.throwException) {
                throw root;
            }
            return this.resultProvider.buildResult(requestEntity, root);
        }
    }

    @Override
    public String saveApi(ApiInfo info) {
        this.notBlank(info.getMethod(), REQUEST_METHOD_REQUIRED);
        this.notBlank(info.getPath(), REQUEST_PATH_REQUIRED);
        this.notBlank(info.getName(), API_NAME_REQUIRED);
        this.notBlank(info.getScript(), SCRIPT_REQUIRED);
        this.isTrue(IoUtils.validateFileName(info.getName()), NAME_INVALID);
        this.isTrue(!this.mappingHandlerMapping.hasRegisterMapping(info), REQUEST_PATH_CONFLICT);
        if (StringUtils.isBlank((CharSequence)info.getId())) {
            this.isTrue(!this.apiServiceProvider.exists(info), API_ALREADY_EXISTS.format(info.getMethod(), info.getPath()));
            this.isTrue(this.apiServiceProvider.insert(info), API_SAVE_FAILURE);
        } else {
            this.isTrue(!this.apiServiceProvider.existsWithoutId(info), API_ALREADY_EXISTS.format(info.getMethod(), info.getPath()));
            Optional<ApiInfo> optional = this.mappingHandlerMapping.getApiInfos().stream().filter(it -> it.getId().equals(info.getId())).findFirst();
            if (optional.isPresent() && !optional.get().equals(info)) {
                this.isTrue(this.apiServiceProvider.update(info), API_SAVE_FAILURE);
                this.apiServiceProvider.backup(info);
            }
        }
        this.mappingHandlerMapping.registerMapping(info, true);
        return info.getId();
    }

    @Override
    public ApiInfo getApiInfo(String id) {
        return (ApiInfo)this.apiServiceProvider.get(id);
    }

    @Override
    public List<ApiInfo> apiList() {
        return this.apiServiceProvider.list();
    }

    @Override
    public boolean deleteApi(String id) {
        boolean success = this.apiServiceProvider.delete(id);
        if (success) {
            this.mappingHandlerMapping.unregisterMapping(id, true);
        }
        return success;
    }

    @Override
    public boolean moveApi(String id, String groupId) {
        this.isTrue(this.groupServiceProvider.containsApiGroup(groupId), GROUP_NOT_FOUND);
        this.isTrue(this.apiServiceProvider.allowMove(id, groupId), NAME_CONFLICT);
        this.isTrue(this.mappingHandlerMapping.move(id, groupId), REQUEST_PATH_CONFLICT);
        return this.apiServiceProvider.move(id, groupId);
    }

    @Override
    public String saveFunction(FunctionInfo functionInfo) {
        this.notBlank(functionInfo.getName(), FUNCTION_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(functionInfo.getName()), NAME_INVALID);
        this.notBlank(functionInfo.getPath(), FUNCTION_PATH_REQUIRED);
        this.notBlank(functionInfo.getScript(), SCRIPT_REQUIRED);
        this.isTrue(!this.magicFunctionManager.hasRegister(functionInfo), FUNCTION_PATH_CONFLICT);
        if (StringUtils.isBlank((CharSequence)functionInfo.getId())) {
            this.isTrue(!this.functionServiceProvider.exists(functionInfo), FUNCTION_ALREADY_EXISTS.format(functionInfo.getPath()));
            this.isTrue(this.functionServiceProvider.insert(functionInfo), FUNCTION_SAVE_FAILURE);
        } else {
            this.isTrue(!this.functionServiceProvider.existsWithoutId(functionInfo), FUNCTION_ALREADY_EXISTS.format(functionInfo.getPath()));
            this.isTrue(this.functionServiceProvider.update(functionInfo), FUNCTION_SAVE_FAILURE);
            this.functionServiceProvider.backup(functionInfo);
        }
        this.magicFunctionManager.register(functionInfo);
        return functionInfo.getId();
    }

    @Override
    public FunctionInfo getFunctionInfo(String id) {
        return (FunctionInfo)this.functionServiceProvider.get(id);
    }

    @Override
    public List<FunctionInfo> functionList() {
        return this.functionServiceProvider.list();
    }

    @Override
    public boolean deleteFunction(String id) {
        boolean success = this.functionServiceProvider.delete(id);
        if (success) {
            this.magicFunctionManager.unregister(id);
        }
        return success;
    }

    @Override
    public boolean moveFunction(String id, String groupId) {
        this.isTrue(this.functionServiceProvider.allowMove(id, groupId), NAME_CONFLICT);
        this.isTrue(this.magicFunctionManager.move(id, groupId), FUNCTION_PATH_CONFLICT);
        return this.functionServiceProvider.move(id, groupId);
    }

    @Override
    public String createGroup(Group group) {
        if (StringUtils.isBlank((CharSequence)group.getParentId())) {
            group.setParentId("0");
        }
        this.notBlank(group.getName(), GROUP_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(group.getName()), NAME_INVALID);
        this.notBlank(group.getType(), GROUP_TYPE_REQUIRED);
        this.isTrue(this.groupServiceProvider.insert(group), GROUP_SAVE_FAILURE);
        if (Objects.equals(group.getType(), "1")) {
            this.mappingHandlerMapping.loadGroup();
        } else {
            this.magicFunctionManager.loadGroup();
        }
        return group.getId();
    }

    @Override
    public boolean updateGroup(Group group) {
        if (StringUtils.isBlank((CharSequence)group.getParentId())) {
            group.setParentId("0");
        }
        this.notBlank(group.getName(), GROUP_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(group.getName()), NAME_INVALID);
        this.notBlank(group.getType(), GROUP_TYPE_REQUIRED);
        boolean isApiGroup = "1".equals(group.getType());
        boolean isFunctionGroup = "2".equals(group.getType());
        if (isApiGroup && this.mappingHandlerMapping.checkGroup(group)) {
            this.isTrue(this.groupServiceProvider.update(group), GROUP_SAVE_FAILURE);
            this.mappingHandlerMapping.updateGroup(group);
            this.apiServiceProvider.reload(group.getId());
            return true;
        }
        if (isFunctionGroup && this.magicFunctionManager.checkGroup(group)) {
            this.isTrue(this.groupServiceProvider.update(group), GROUP_SAVE_FAILURE);
            this.magicFunctionManager.updateGroup(group);
            this.functionServiceProvider.reload(group.getId());
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteGroup(String groupId) {
        boolean success;
        boolean isApi = true;
        TreeNode<Group> treeNode = this.groupServiceProvider.apiGroupTree().findTreeNode(group -> group.getId().equals(groupId));
        if (treeNode == null) {
            treeNode = this.groupServiceProvider.functionGroupTree().findTreeNode(group -> group.getId().equals(groupId));
            this.notNull(treeNode, GROUP_NOT_FOUND);
            isApi = false;
        }
        List<String> children = treeNode.flat().stream().map(Group::getId).collect(Collectors.toList());
        if (isApi) {
            success = this.apiServiceProvider.deleteGroup(groupId, children);
            if (success) {
                this.mappingHandlerMapping.deleteGroup(children);
                children.forEach(this.groupServiceProvider::delete);
                this.mappingHandlerMapping.loadGroup();
            }
        } else {
            success = this.functionServiceProvider.deleteGroup(groupId, children);
            if (success) {
                this.magicFunctionManager.deleteGroup(children);
                children.forEach(this.groupServiceProvider::delete);
                this.magicFunctionManager.loadGroup();
            }
        }
        return success;
    }

    @Override
    public List<Group> groupList(String type) {
        return this.groupServiceProvider.groupList(type);
    }

    @Override
    public String getModuleName() {
        return "magic";
    }
}

