/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ssssssss.magicapi.exception.MagicAPIException;
import org.ssssssss.magicapi.modules.BoundSql;
import org.ssssssss.magicapi.modules.SQLModule;
import org.ssssssss.magicapi.modules.table.Where;
import org.ssssssss.script.annotation.Comment;

public class NamedTable {
    String tableName;
    SQLModule sqlModule;
    String primary;
    Map<String, Object> columns = new HashMap<String, Object>();
    List<String> fields = new ArrayList<String>();
    List<String> groups = new ArrayList<String>();
    List<String> orders = new ArrayList<String>();
    Function<String, String> rowMapColumnMapper;
    Object defaultPrimaryValue;
    Where where = new Where(this);

    public NamedTable(String tableName, SQLModule sqlModule, Function<String, String> rowMapColumnMapper) {
        this.tableName = tableName;
        this.sqlModule = sqlModule;
        this.rowMapColumnMapper = rowMapColumnMapper;
    }

    @Comment(value="\u8bbe\u7f6e\u4e3b\u952e\u540d\uff0cupdate\u65f6\u4f7f\u7528")
    public NamedTable primary(String primary) {
        return this.primary(primary, null);
    }

    @Comment(value="\u8bbe\u7f6e\u4e3b\u952e\u540d\uff0c\u5e76\u8bbe\u7f6e\u9ed8\u8ba4\u4e3b\u952e\u503c(\u4e3b\u8981\u7528\u4e8einsert)")
    public NamedTable primary(String primary, Object defaultPrimaryValue) {
        this.primary = this.rowMapColumnMapper.apply(primary);
        this.defaultPrimaryValue = defaultPrimaryValue;
        return this;
    }

    @Comment(value="\u62fc\u63a5where")
    public Where where() {
        return this.where;
    }

    @Comment(value="\u8bbe\u7f6e\u5355\u5217\u7684\u503c")
    public NamedTable column(@Comment(value="\u5217\u540d") String key, @Comment(value="\u503c") Object value) {
        this.columns.put(this.rowMapColumnMapper.apply(key), value);
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u67e5\u8be2\u7684\u5217\uff0c\u5982`columns('a','b','c')`")
    public NamedTable columns(String ... columns) {
        if (columns != null) {
            for (String column : columns) {
                this.column(column);
            }
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u67e5\u8be2\u7684\u5217\uff0c\u5982`columns(['a','b','c'])`")
    public NamedTable columns(Collection<String> columns) {
        if (columns != null) {
            columns.stream().filter(StringUtils::isNotBlank).map(this.rowMapColumnMapper).forEach(this.fields::add);
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u67e5\u8be2\u7684\u5217\uff0c\u5982`column('a')`")
    public NamedTable column(String column) {
        if (StringUtils.isNotBlank((CharSequence)column)) {
            this.fields.add(this.rowMapColumnMapper.apply(column));
        }
        return this;
    }

    @Comment(value="\u62fc\u63a5`order by xxx asc/desc`")
    public NamedTable orderBy(@Comment(value="\u8981\u6392\u5e8f\u7684\u5217") String column, @Comment(value="`asc`\u6216`desc`") String sort) {
        this.orders.add(column + " " + sort);
        return this;
    }

    @Comment(value="\u62fc\u63a5`order by xxx asc`")
    public NamedTable orderBy(@Comment(value="\u8981\u6392\u5e8f\u7684\u5217") String column) {
        return this.orderBy(column, "asc");
    }

    @Comment(value="\u62fc\u63a5`order by xxx desc`")
    public NamedTable orderByDesc(@Comment(value="\u8981\u6392\u5e8f\u7684\u5217") String column) {
        return this.orderBy(column, "desc");
    }

    @Comment(value="\u62fc\u63a5`group by`")
    public NamedTable groupBy(String ... columns) {
        this.groups.addAll(Arrays.asList(columns));
        return this;
    }

    private List<Map.Entry<String, Object>> filterNotBlanks() {
        return this.columns.entrySet().stream().filter(it -> StringUtils.isNotBlank((CharSequence)Objects.toString(it.getValue(), ""))).collect(Collectors.toList());
    }

    @Comment(value="\u6267\u884c\u63d2\u5165,\u8fd4\u56de\u4e3b\u952e")
    public Object insert() {
        return this.insert(null);
    }

    @Comment(value="\u6267\u884c\u63d2\u5165,\u8fd4\u56de\u4e3b\u952e")
    public Object insert(@Comment(value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        List<Map.Entry<String, Object>> entries;
        if (data != null) {
            data.forEach((key, value) -> this.columns.put(this.rowMapColumnMapper.apply((String)key), value));
        }
        if (this.defaultPrimaryValue != null && StringUtils.isBlank((CharSequence)Objects.toString(this.columns.getOrDefault(this.primary, "")))) {
            this.columns.put(this.primary, this.defaultPrimaryValue);
        }
        if ((entries = this.filterNotBlanks()).isEmpty()) {
            throw new MagicAPIException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ");
        builder.append(this.tableName);
        builder.append("(");
        builder.append(StringUtils.join((Object[])entries.stream().map(Map.Entry::getKey).toArray(), (String)","));
        builder.append(") values (");
        builder.append(StringUtils.join(Collections.nCopies(entries.size(), "?"), (String)","));
        builder.append(")");
        return this.sqlModule.insert(new BoundSql(builder.toString(), entries.stream().map(Map.Entry::getValue).collect(Collectors.toList()), this.sqlModule), this.primary);
    }

    @Comment(value="\u6267\u884cdelete\u8bed\u53e5(\u7269\u7406\u5220\u9664)")
    public int delete() {
        if (this.where.isEmpty()) {
            throw new MagicAPIException("delete\u8bed\u53e5\u4e0d\u80fd\u6ca1\u6709\u6761\u4ef6");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("delete from ");
        builder.append(this.tableName);
        builder.append(this.where.getSql());
        return this.sqlModule.update(new BoundSql(builder.toString(), this.where.getParams(), this.sqlModule));
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save() {
        return this.save(null);
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(@Comment(value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        if (StringUtils.isBlank((CharSequence)this.primary)) {
            throw new MagicAPIException("\u8bf7\u8bbe\u7f6e\u4e3b\u952e");
        }
        if (StringUtils.isNotBlank((CharSequence)Objects.toString(this.columns.get(this.primary), "")) || data != null && StringUtils.isNotBlank((CharSequence)Objects.toString(data.get(this.primary), ""))) {
            return this.update(data);
        }
        return this.insert(data);
    }

    @Comment(value="\u6267\u884c`select`\u67e5\u8be2")
    public List<Map<String, Object>> select() {
        return this.sqlModule.select(this.buildSelect());
    }

    @Comment(value="\u6267\u884c`selectOne`\u67e5\u8be2")
    public Map<String, Object> selectOne() {
        return this.sqlModule.selectOne(this.buildSelect());
    }

    private BoundSql buildSelect() {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        if (this.fields.isEmpty()) {
            builder.append("*");
        } else {
            builder.append(StringUtils.join(this.fields, (String)","));
        }
        builder.append(" from ").append(this.tableName);
        ArrayList<Object> params = new ArrayList<Object>();
        if (!this.where.isEmpty()) {
            builder.append(this.where.getSql());
            params.addAll(this.where.getParams());
        }
        if (!this.orders.isEmpty()) {
            builder.append(" order by ");
            builder.append(String.join((CharSequence)",", this.orders));
        }
        if (!this.groups.isEmpty()) {
            builder.append(" group by ");
            builder.append(String.join((CharSequence)",", this.groups));
        }
        return new BoundSql(builder.toString(), params, this.sqlModule);
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2")
    public Object page() {
        return this.sqlModule.page(this.buildSelect());
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update() {
        return this.update(null);
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(@Comment(value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        List<Map.Entry<String, Object>> entries;
        if (null != data) {
            data.forEach((key, value) -> this.columns.put(this.rowMapColumnMapper.apply((String)key), value));
        }
        Object primaryValue = null;
        if (StringUtils.isNotBlank((CharSequence)this.primary)) {
            primaryValue = this.columns.remove(this.primary);
        }
        if ((entries = this.filterNotBlanks()).isEmpty()) {
            throw new MagicAPIException("\u8981\u4fee\u6539\u7684\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("update ");
        builder.append(this.tableName);
        builder.append(" set ");
        ArrayList<Object> params = new ArrayList<Object>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, Object> entry = entries.get(i);
            builder.append(entry.getKey()).append(" = ?");
            params.add(entry.getValue());
            if (i + 1 >= size) continue;
            builder.append(",");
        }
        if (!this.where.isEmpty()) {
            builder.append(this.where.getSql());
            params.addAll(this.where.getParams());
        } else if (primaryValue != null) {
            builder.append(" where ").append(this.primary).append(" = ?");
            params.add(primaryValue);
        } else {
            throw new MagicAPIException("\u4e3b\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sqlModule.update(new BoundSql(builder.toString(), params, this.sqlModule));
    }
}

