/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.ssssssss.magicapi.adapter.ColumnMapperAdapter;
import org.ssssssss.magicapi.adapter.DialectAdapter;
import org.ssssssss.magicapi.cache.SqlCache;
import org.ssssssss.magicapi.config.MagicDynamicDataSource;
import org.ssssssss.magicapi.config.MagicModule;
import org.ssssssss.magicapi.context.RequestContext;
import org.ssssssss.magicapi.dialect.Dialect;
import org.ssssssss.magicapi.interceptor.SQLInterceptor;
import org.ssssssss.magicapi.model.Page;
import org.ssssssss.magicapi.model.RequestEntity;
import org.ssssssss.magicapi.modules.BoundSql;
import org.ssssssss.magicapi.modules.Transaction;
import org.ssssssss.magicapi.modules.table.NamedTable;
import org.ssssssss.magicapi.provider.PageProvider;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.annotation.UnableCall;

public class SQLModule
extends HashMap<String, SQLModule>
implements MagicModule {
    private MagicDynamicDataSource dynamicDataSource;
    private MagicDynamicDataSource.DataSourceNode dataSourceNode;
    private PageProvider pageProvider;
    private ResultProvider resultProvider;
    private ColumnMapperAdapter columnMapperAdapter;
    private DialectAdapter dialectAdapter;
    private RowMapper<Map<String, Object>> columnMapRowMapper;
    private Function<String, String> rowMapColumnMapper;
    private SqlCache sqlCache;
    private String cacheName;
    private List<SQLInterceptor> sqlInterceptors;
    private long ttl;

    public SQLModule() {
    }

    public SQLModule(MagicDynamicDataSource dynamicDataSource) {
        this.dynamicDataSource = dynamicDataSource;
        this.dataSourceNode = dynamicDataSource.getDataSource();
    }

    @UnableCall
    public void setPageProvider(PageProvider pageProvider) {
        this.pageProvider = pageProvider;
    }

    @UnableCall
    public void setResultProvider(ResultProvider resultProvider) {
        this.resultProvider = resultProvider;
    }

    @UnableCall
    public void setColumnMapperProvider(ColumnMapperAdapter columnMapperAdapter) {
        this.columnMapperAdapter = columnMapperAdapter;
    }

    @UnableCall
    public void setDialectAdapter(DialectAdapter dialectAdapter) {
        this.dialectAdapter = dialectAdapter;
    }

    @UnableCall
    public void setColumnMapRowMapper(RowMapper<Map<String, Object>> columnMapRowMapper) {
        this.columnMapRowMapper = columnMapRowMapper;
    }

    @UnableCall
    public void setRowMapColumnMapper(Function<String, String> rowMapColumnMapper) {
        this.rowMapColumnMapper = rowMapColumnMapper;
    }

    private void setDynamicDataSource(MagicDynamicDataSource dynamicDataSource) {
        this.dynamicDataSource = dynamicDataSource;
    }

    @UnableCall
    public void setSqlInterceptors(List<SQLInterceptor> sqlInterceptors) {
        this.sqlInterceptors = sqlInterceptors;
    }

    private void setDataSourceNode(MagicDynamicDataSource.DataSourceNode dataSourceNode) {
        this.dataSourceNode = dataSourceNode;
    }

    protected String getCacheName() {
        return this.cacheName;
    }

    private void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    protected long getTtl() {
        return this.ttl;
    }

    private void setTtl(long ttl) {
        this.ttl = ttl;
    }

    protected SqlCache getSqlCache() {
        return this.sqlCache;
    }

    @UnableCall
    public void setSqlCache(SqlCache sqlCache) {
        this.sqlCache = sqlCache;
    }

    @UnableCall
    private SQLModule cloneSQLModule() {
        SQLModule sqlModule = new SQLModule();
        sqlModule.setDynamicDataSource(this.dynamicDataSource);
        sqlModule.setDataSourceNode(this.dataSourceNode);
        sqlModule.setPageProvider(this.pageProvider);
        sqlModule.setColumnMapperProvider(this.columnMapperAdapter);
        sqlModule.setColumnMapRowMapper(this.columnMapRowMapper);
        sqlModule.setRowMapColumnMapper(this.rowMapColumnMapper);
        sqlModule.setSqlCache(this.sqlCache);
        sqlModule.setTtl(this.ttl);
        sqlModule.setResultProvider(this.resultProvider);
        sqlModule.setDialectAdapter(this.dialectAdapter);
        sqlModule.setSqlInterceptors(this.sqlInterceptors);
        return sqlModule;
    }

    @Comment(value="\u5f00\u542f\u4e8b\u52a1\uff0c\u5e76\u5728\u56de\u8c03\u4e2d\u5904\u7406")
    public Object transaction(@Comment(value="\u56de\u8c03\u51fd\u6570\uff0c\u5982\uff1a()=>{....}") Function<?, ?> function) {
        Transaction transaction = this.transaction();
        try {
            Object val = function.apply(null);
            transaction.commit();
            return val;
        }
        catch (Throwable throwable) {
            transaction.rollback();
            throw throwable;
        }
    }

    @Comment(value="\u5f00\u542f\u4e8b\u52a1\uff0c\u8fd4\u56de\u4e8b\u52a1\u5bf9\u8c61")
    public Transaction transaction() {
        return new Transaction(this.dataSourceNode.getDataSourceTransactionManager());
    }

    @Comment(value="\u4f7f\u7528\u7f13\u5b58")
    public SQLModule cache(@Comment(value="\u7f13\u5b58\u540d") String cacheName, @Comment(value="\u8fc7\u671f\u65f6\u95f4") long ttl) {
        if (cacheName == null) {
            return this;
        }
        SQLModule sqlModule = this.cloneSQLModule();
        sqlModule.setCacheName(cacheName);
        sqlModule.setTtl(ttl);
        return sqlModule;
    }

    @Comment(value="\u4f7f\u7528\u7f13\u5b58\uff0c\u8fc7\u671f\u65f6\u95f4\u91c7\u7528\u9ed8\u8ba4\u914d\u7f6e")
    public SQLModule cache(@Comment(value="\u7f13\u5b58\u540d") String cacheName) {
        return this.cache(cacheName, 0L);
    }

    @Comment(value="\u91c7\u7528\u9a7c\u5cf0\u5217\u540d")
    public SQLModule camel() {
        return this.columnCase("camel");
    }

    @Comment(value="\u91c7\u7528\u5e15\u65af\u5361\u5217\u540d")
    public SQLModule pascal() {
        return this.columnCase("pascal");
    }

    @Comment(value="\u91c7\u7528\u5168\u5c0f\u5199\u5217\u540d")
    public SQLModule lower() {
        return this.columnCase("lower");
    }

    @Comment(value="\u91c7\u7528\u5168\u5927\u5199\u5217\u540d")
    public SQLModule upper() {
        return this.columnCase("upper");
    }

    @Comment(value="\u5217\u540d\u4fdd\u6301\u539f\u6837")
    public SQLModule normal() {
        return this.columnCase("default");
    }

    @Comment(value="\u6307\u5b9a\u5217\u540d\u8f6c\u6362")
    public SQLModule columnCase(String name) {
        SQLModule sqlModule = this.cloneSQLModule();
        sqlModule.setColumnMapRowMapper(this.columnMapperAdapter.getColumnMapRowMapper(name));
        sqlModule.setRowMapColumnMapper(this.columnMapperAdapter.getRowMapColumnMapper(name));
        return sqlModule;
    }

    @Override
    public SQLModule get(Object key) {
        SQLModule sqlModule = this.cloneSQLModule();
        if (key == null) {
            sqlModule.setDataSourceNode(this.dynamicDataSource.getDataSource());
        } else {
            sqlModule.setDataSourceNode(this.dynamicDataSource.getDataSource(key.toString()));
        }
        return sqlModule;
    }

    @Comment(value="\u67e5\u8be2SQL\uff0c\u8fd4\u56deList\u7c7b\u578b\u7ed3\u679c")
    public List<Map<String, Object>> select(@Comment(value="`SQL`\u8bed\u53e5") String sql) {
        return this.select(new BoundSql(sql, this));
    }

    @UnableCall
    public List<Map<String, Object>> select(BoundSql boundSql) {
        return boundSql.getCacheValue(this.sqlInterceptors, () -> this.dataSourceNode.getJdbcTemplate().query(boundSql.getSql(), this.columnMapRowMapper, boundSql.getParameters()));
    }

    @Comment(value="\u6267\u884cupdate\u64cd\u4f5c\uff0c\u8fd4\u56de\u53d7\u5f71\u54cd\u884c\u6570")
    public int update(@Comment(value="`SQL`\u8bed\u53e5") String sql) {
        return this.update(new BoundSql(sql));
    }

    @UnableCall
    public int update(BoundSql boundSql) {
        this.sqlInterceptors.forEach((? super T sqlInterceptor) -> sqlInterceptor.preHandle(boundSql));
        int value = this.dataSourceNode.getJdbcTemplate().update(boundSql.getSql(), boundSql.getParameters());
        if (this.cacheName != null) {
            this.sqlCache.delete(this.cacheName);
        }
        return value;
    }

    @Comment(value="\u6267\u884cinsert\u64cd\u4f5c\uff0c\u8fd4\u56de\u63d2\u5165\u4e3b\u952e")
    public long insert(@Comment(value="`SQL`\u8bed\u53e5") String sql) {
        MagicKeyHolder magicKeyHolder = new MagicKeyHolder();
        this.insert(new BoundSql(sql), magicKeyHolder);
        return magicKeyHolder.getLongKey();
    }

    @Comment(value="\u6267\u884cinsert\u64cd\u4f5c\uff0c\u8fd4\u56de\u63d2\u5165\u4e3b\u952e")
    public Object insert(@Comment(value="`SQL`\u8bed\u53e5") String sql, @Comment(value="\u4e3b\u952e\u5217") String primary) {
        return this.insert(new BoundSql(sql), primary);
    }

    void insert(BoundSql boundSql, MagicKeyHolder keyHolder) {
        this.sqlInterceptors.forEach((? super T sqlInterceptor) -> sqlInterceptor.preHandle(boundSql));
        this.dataSourceNode.getJdbcTemplate().update(con -> {
            PreparedStatement ps = keyHolder.createPrepareStatement(con, boundSql.getSql());
            new ArgumentPreparedStatementSetter(boundSql.getParameters()).setValues(ps);
            return ps;
        }, (KeyHolder)keyHolder);
        if (this.cacheName != null) {
            this.sqlCache.delete(this.cacheName);
        }
    }

    @UnableCall
    public Object insert(BoundSql boundSql, String primary) {
        MagicKeyHolder keyHolder = new MagicKeyHolder(primary);
        this.insert(boundSql, keyHolder);
        return keyHolder.getObjectKey();
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5206\u9875\u6761\u4ef6\u81ea\u52a8\u83b7\u53d6")
    public Object page(@Comment(value="`SQL`\u8bed\u53e5") String sql) {
        return this.page(new BoundSql(sql, this));
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5206\u9875\u6761\u4ef6\u624b\u52a8\u4f20\u5165")
    public Object page(@Comment(value="`SQL`\u8bed\u53e5") String sql, @Comment(value="\u9650\u5236\u6761\u6570") long limit, @Comment(value="\u8df3\u8fc7\u6761\u6570") long offset) {
        BoundSql boundSql = new BoundSql(sql, this);
        return this.page(boundSql, new Page(limit, offset));
    }

    @UnableCall
    public Object page(BoundSql boundSql) {
        Page page = this.pageProvider.getPage(MagicScriptContext.get());
        return this.page(boundSql, page);
    }

    private Object page(BoundSql boundSql, Page page) {
        Dialect dialect = this.dataSourceNode.getDialect(this.dialectAdapter);
        BoundSql countBoundSql = boundSql.copy(dialect.getCountSql(boundSql.getSql()));
        int count = countBoundSql.getCacheValue(this.sqlInterceptors, () -> (Integer)this.dataSourceNode.getJdbcTemplate().queryForObject(countBoundSql.getSql(), Integer.class, countBoundSql.getParameters()));
        List list = null;
        if (count > 0) {
            BoundSql pageBoundSql = this.buildPageBoundSql(dialect, boundSql, page.getOffset(), page.getLimit());
            list = pageBoundSql.getCacheValue(this.sqlInterceptors, () -> this.dataSourceNode.getJdbcTemplate().query(pageBoundSql.getSql(), this.columnMapRowMapper, pageBoundSql.getParameters()));
        }
        RequestEntity requestEntity = RequestContext.getRequestEntity();
        return this.resultProvider.buildPageResult(requestEntity, page, count, list);
    }

    @Comment(value="\u67e5\u8be2int\u503c\uff0c\u9002\u5408\u5355\u884c\u5355\u5217int\u7684\u7ed3\u679c")
    public Integer selectInt(@Comment(value="`SQL`\u8bed\u53e5") String sql) {
        BoundSql boundSql = new BoundSql(sql, this);
        return boundSql.getCacheValue(this.sqlInterceptors, () -> (Integer)this.dataSourceNode.getJdbcTemplate().queryForObject(boundSql.getSql(), boundSql.getParameters(), Integer.class));
    }

    @Comment(value="\u67e5\u8be2\u5355\u6761\u7ed3\u679c\uff0c\u67e5\u4e0d\u5230\u8fd4\u56denull")
    public Map<String, Object> selectOne(@Comment(value="`SQL`\u8bed\u53e5") String sql) {
        return this.selectOne(new BoundSql(sql, this));
    }

    @UnableCall
    public Map<String, Object> selectOne(BoundSql boundSql) {
        return boundSql.getCacheValue(this.sqlInterceptors, () -> {
            Dialect dialect = this.dataSourceNode.getDialect(this.dialectAdapter);
            BoundSql pageBoundSql = this.buildPageBoundSql(dialect, boundSql, 0L, 1L);
            List list = this.dataSourceNode.getJdbcTemplate().query(pageBoundSql.getSql(), this.columnMapRowMapper, pageBoundSql.getParameters());
            return list.size() > 0 ? (Map)list.get(0) : null;
        });
    }

    @Comment(value="\u67e5\u8be2\u5355\u884c\u5355\u5217\u7684\u503c")
    public Object selectValue(@Comment(value="`SQL`\u8bed\u53e5") String sql) {
        BoundSql boundSql = new BoundSql(sql, this);
        return boundSql.getCacheValue(this.sqlInterceptors, () -> {
            Dialect dialect = this.dataSourceNode.getDialect(this.dialectAdapter);
            BoundSql pageBoundSql = this.buildPageBoundSql(dialect, boundSql, 0L, 1L);
            return this.dataSourceNode.getJdbcTemplate().queryForObject(pageBoundSql.getSql(), Object.class, pageBoundSql.getParameters());
        });
    }

    @Comment(value="\u6307\u5b9atable\uff0c\u8fdb\u884c\u5355\u8868\u64cd\u4f5c")
    public NamedTable table(String tableName) {
        return new NamedTable(tableName, this, this.rowMapColumnMapper);
    }

    private BoundSql buildPageBoundSql(Dialect dialect, BoundSql boundSql, long offset, long limit) {
        String pageSql = dialect.getPageSql(boundSql.getSql(), boundSql, offset, limit);
        return boundSql.copy(pageSql);
    }

    @Override
    @UnableCall
    public String getModuleName() {
        return "db";
    }

    class MagicKeyHolder
    extends GeneratedKeyHolder {
        private final boolean useGeneratedKeys;
        private final String primary;

        public MagicKeyHolder() {
            this(null);
        }

        public MagicKeyHolder(String primary) {
            this.primary = primary;
            this.useGeneratedKeys = StringUtils.isBlank((CharSequence)primary);
        }

        PreparedStatement createPrepareStatement(Connection connection, String sql) throws SQLException {
            if (this.useGeneratedKeys) {
                return connection.prepareStatement(sql, 1);
            }
            return connection.prepareStatement(sql, new String[]{this.primary});
        }

        public long getLongKey() throws InvalidDataAccessApiUsageException, DataRetrievalFailureException {
            Number key = super.getKey();
            if (key == null) {
                return -1L;
            }
            return key.longValue();
        }

        public Object getObjectKey() {
            if (this.useGeneratedKeys) {
                return this.getLongKey();
            }
            List keyList = this.getKeyList();
            if (keyList.isEmpty()) {
                return null;
            }
            Iterator keyIterator = ((Map)keyList.get(0)).values().iterator();
            return keyIterator.hasNext() ? keyIterator.next() : null;
        }
    }
}

