/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.ssssssss.magicapi.config.MagicModule;
import org.ssssssss.script.reflection.AbstractReflection;
import org.ssssssss.script.reflection.JavaInvoker;

public class MongoModule
extends HashMap<String, Object>
implements MagicModule {
    private static final Logger logger = LoggerFactory.getLogger(MongoModule.class);
    private final MongoTemplate mongoTemplate;
    private final JavaInvoker<Method> mongoDbFactoryInvoker;
    private JavaInvoker<Method> invoker;

    public MongoModule(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        AbstractReflection reflection = AbstractReflection.getInstance();
        this.mongoDbFactoryInvoker = reflection.getMethod((Object)this.mongoTemplate, "getMongoDbFactory", new Object[0]);
        if (this.mongoDbFactoryInvoker != null) {
            try {
                Object factory = this.mongoDbFactoryInvoker.invoke0((Object)this.mongoTemplate, null, new Object[0]);
                this.invoker = reflection.getMethod(factory, "getDb", new Object[]{""});
                if (this.invoker == null) {
                    this.invoker = reflection.getMethod(factory, "getMongoDatabase", new Object[]{""});
                }
            }
            catch (Throwable e) {
                logger.error("mongo\u6a21\u5757\u521d\u59cb\u5316\u5931\u8d25", e);
            }
        } else {
            logger.error("mongo\u6a21\u5757\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    public Object get(final Object databaseName) {
        return databaseName == null ? null : new HashMap<String, MongoCollection<Document>>(){

            @Override
            public MongoCollection<Document> get(Object collection) {
                if (collection == null) {
                    return null;
                }
                try {
                    Object factory = MongoModule.this.mongoDbFactoryInvoker.invoke0((Object)MongoModule.this.mongoTemplate, null, new Object[0]);
                    MongoDatabase database = (MongoDatabase)MongoModule.this.invoker.invoke0(factory, null, new Object[]{databaseName.toString()});
                    return database.getCollection(collection.toString());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        };
    }

    @Override
    public String getModuleName() {
        return "mongo";
    }
}

