/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.ssssssss.magicapi.config.MagicModule;
import org.ssssssss.script.annotation.Comment;

public class HttpModule
implements MagicModule {
    private final RestTemplate template;
    private final HttpHeaders httpHeaders = new HttpHeaders();
    private final Class<?> responseType = Object.class;
    private final MultiValueMap<String, Object> params = new LinkedMultiValueMap();
    private final MultiValueMap<String, Object> data = new LinkedMultiValueMap();
    private final Map<String, ?> variables = new HashMap();
    private String url;
    private HttpMethod method = HttpMethod.GET;
    private HttpEntity<Object> entity = null;
    private Object requestBody;

    public HttpModule(RestTemplate template) {
        this.template = template;
    }

    public HttpModule(RestTemplate template, String url) {
        this.template = template;
        this.url = url;
    }

    @Override
    public String getModuleName() {
        return "http";
    }

    @Comment(value="\u521b\u5efa\u8fde\u63a5")
    public HttpModule connect(@Comment(value="\u76ee\u6807URL") String url) {
        return new HttpModule(this.template, url);
    }

    @Comment(value="\u8bbe\u7f6eURL\u53c2\u6570")
    public HttpModule param(@Comment(value="\u53c2\u6570\u540d") String key, Object ... values) {
        if (values != null) {
            for (Object value : values) {
                this.params.add((Object)key, value);
            }
        }
        return this;
    }

    @Comment(value="\u6279\u91cf\u8bbe\u7f6eURL\u53c2\u6570")
    public HttpModule param(@Comment(value="\u53c2\u6570\u503c") Map<String, Object> values) {
        values.forEach((key, value) -> this.param((String)key, Objects.toString(value, "")));
        return this;
    }

    @Comment(value="\u8bbe\u7f6eform\u53c2\u6570")
    public HttpModule data(@Comment(value="\u53c2\u6570\u540d") String key, Object ... values) {
        if (values != null) {
            for (Object value : values) {
                this.data.add((Object)key, value);
            }
        }
        return this;
    }

    @Comment(value="\u6279\u91cf\u8bbe\u7f6eform\u53c2\u6570")
    public HttpModule data(@Comment(value="\u53c2\u6570\u503c") Map<String, Object> values) {
        values.forEach((key, value) -> this.data((String)key, Objects.toString(value, "")));
        return this;
    }

    @Comment(value="\u8bbe\u7f6eheader")
    public HttpModule header(@Comment(value="header\u540d") String key, @Comment(value="header\u503c") String value) {
        this.httpHeaders.add(key, value);
        return this;
    }

    @Comment(value="\u6279\u91cf\u8bbe\u7f6eheader")
    public HttpModule header(@Comment(value="header\u503c") Map<String, Object> values) {
        values.entrySet().stream().filter(it -> it.getValue() != null).forEach(entry -> this.header((String)entry.getKey(), entry.getValue().toString()));
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u8bf7\u6c42\u65b9\u6cd5\uff0c\u9ed8\u8ba4GET")
    public HttpModule method(@Comment(value="\u8bf7\u6c42\u65b9\u6cd5") HttpMethod method) {
        this.method = method;
        return this;
    }

    @Comment(value="\u8bbe\u7f6e`RequestBody`")
    public HttpModule body(@Comment(value="`RequestBody`") Object requestBody) {
        this.requestBody = requestBody;
        this.contentType(MediaType.APPLICATION_JSON);
        return this;
    }

    @Comment(value="\u81ea\u5b9a\u4e49`HttpEntity`")
    public HttpModule entity(@Comment(value="`HttpEntity`") HttpEntity<Object> entity) {
        this.entity = entity;
        return this;
    }

    @Comment(value="\u8bbe\u7f6e`ContentType`")
    public HttpModule contentType(@Comment(value="Content-Type\u503c") String contentType) {
        return this.contentType(MediaType.parseMediaType((String)contentType));
    }

    @Comment(value="\u8bbe\u7f6e`ContentType`")
    public HttpModule contentType(@Comment(value="Content-Type\u503c") MediaType mediaType) {
        this.httpHeaders.setContentType(mediaType);
        return this;
    }

    @Comment(value="\u53d1\u9001`POST`\u8bf7\u6c42")
    public ResponseEntity<Object> post() {
        this.method(HttpMethod.POST);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`GET`\u8bf7\u6c42")
    public ResponseEntity<Object> get() {
        this.method(HttpMethod.GET);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`PUT`\u8bf7\u6c42")
    public ResponseEntity<Object> put() {
        this.method(HttpMethod.PUT);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`DELETE`\u8bf7\u6c42")
    public ResponseEntity<Object> delete() {
        this.method(HttpMethod.DELETE);
        return this.execute();
    }

    @Comment(value="\u6267\u884c\u8bf7\u6c42")
    public ResponseEntity<Object> execute() {
        String params;
        if (!this.params.isEmpty() && StringUtils.isNotBlank((CharSequence)(params = this.params.entrySet().stream().map(it -> ((List)it.getValue()).stream().map(value -> (String)it.getKey() + "=" + value).collect(Collectors.joining("&"))).collect(Collectors.joining("&"))))) {
            this.url = this.url + (this.url.contains("?") ? "&" : "?") + params;
        }
        this.entity = !this.data.isEmpty() ? new HttpEntity(this.data, (MultiValueMap)this.httpHeaders) : (this.entity == null && this.requestBody != null ? new HttpEntity(this.requestBody, (MultiValueMap)this.httpHeaders) : new HttpEntity(null, (MultiValueMap)this.httpHeaders));
        return this.template.exchange(this.url, this.method, this.entity, Object.class, new Object[]{this.responseType, this.variables});
    }
}

