/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ssssssss.magicapi.cache.SqlCache;
import org.ssssssss.magicapi.context.RequestContext;
import org.ssssssss.magicapi.interceptor.SQLInterceptor;
import org.ssssssss.magicapi.modules.SQLModule;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.parsing.GenericTokenParser;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;

public class BoundSql {
    private static final GenericTokenParser concatTokenParser = new GenericTokenParser("${", "}", false);
    private static final GenericTokenParser replaceTokenParser = new GenericTokenParser("#{", "}", true);
    private static final GenericTokenParser ifTokenParser = new GenericTokenParser("?{", "}", true);
    private static final GenericTokenParser ifParamTokenParser = new GenericTokenParser("?{", ",", true);
    private static final Pattern REPLACE_MULTI_WHITE_LINE = Pattern.compile("(\r?\n(\\s*\r?\n)+)");
    private String sql;
    private List<Object> parameters = new ArrayList<Object>();
    private SqlCache sqlCache;
    private String cacheName;
    private long ttl;

    public BoundSql(String sql, List<Object> parameters, SQLModule sqlModule) {
        this.sql = sql;
        this.parameters = parameters;
        this.sqlCache = sqlModule.getSqlCache();
        this.cacheName = sqlModule.getCacheName();
        this.ttl = sqlModule.getTtl();
    }

    BoundSql(String sql) {
        MagicScriptContext context = MagicScriptContext.get();
        this.sql = ifTokenParser.parse(sql.trim(), text -> {
            AtomicBoolean ifTrue = new AtomicBoolean(false);
            String val = ifParamTokenParser.parse("?{" + text, param -> {
                ifTrue.set(BooleanLiteral.isTrue((Object)context.eval(param)));
                return null;
            });
            return ifTrue.get() ? val : "";
        });
        this.sql = concatTokenParser.parse(this.sql, text -> String.valueOf(context.eval(text)));
        this.sql = replaceTokenParser.parse(this.sql, text -> {
            Object value = context.eval(text);
            if (value == null) {
                this.parameters.add(null);
                return "?";
            }
            try {
                List objects = StreamExtension.arrayLikeToList((Object)value);
                this.parameters.addAll(objects);
                return IntStream.range(0, objects.size()).mapToObj(t -> "?").collect(Collectors.joining(","));
            }
            catch (Exception e) {
                this.parameters.add(value);
                return "?";
            }
        });
        this.sql = this.sql == null ? null : REPLACE_MULTI_WHITE_LINE.matcher(this.sql.trim()).replaceAll("\r\n");
    }

    BoundSql(String sql, SQLModule sqlModule) {
        this(sql);
        this.sqlCache = sqlModule.getSqlCache();
        this.cacheName = sqlModule.getCacheName();
        this.ttl = sqlModule.getTtl();
    }

    private BoundSql() {
    }

    BoundSql copy(String newSql) {
        BoundSql boundSql = new BoundSql();
        boundSql.setParameters(new ArrayList<Object>(this.parameters));
        boundSql.setSql(this.sql);
        boundSql.ttl = this.ttl;
        boundSql.cacheName = this.cacheName;
        boundSql.sqlCache = this.sqlCache;
        boundSql.sql = newSql;
        return boundSql;
    }

    public void addParameter(Object value) {
        this.parameters.add(value);
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Object[] getParameters() {
        return this.parameters.toArray();
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    private <T> T getCacheValue(String sql, Object[] params, Supplier<T> supplier) {
        if (this.cacheName == null) {
            return supplier.get();
        }
        String cacheKey = this.sqlCache.buildSqlCacheKey(sql, params);
        Object cacheValue = this.sqlCache.get(this.cacheName, cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        T value = supplier.get();
        this.sqlCache.put(this.cacheName, cacheKey, value, this.ttl);
        return value;
    }

    <T> T getCacheValue(List<SQLInterceptor> interceptors, Supplier<T> supplier) {
        interceptors.forEach(interceptor -> interceptor.preHandle(this, RequestContext.getRequestEntity()));
        return this.getCacheValue(this.getSql(), this.getParameters(), supplier);
    }
}

